/* Xymon Client V1.2 for VSE/ESA and z/VSE
    Copyright (C) 2003-2010 Richard Smrcina
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
 
    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html            */
/*  This program will collect data from LSTCAT and DITTO listings
    and store the results in a library member (HOBDSKRS.Z) for
    reporting by the Xymon disk test. - Rich Smrcina
 
    RKS: Original V1.0 release 09/19/2005
    RKS: Change to allow BIG-3390 support for cylinder allocations,
         contributed by Steve Williamson of Santa Fe Community College
         12/01/2005
    RKS: Fix problem handling multi-volume VSAM catalogs 12/12/2005
    RKS: Changed options to read all data from HOBVARS.Z 05/24/2006
    RKS: Write library member with fileid of user catalog as read from
         HOBVARS.Z                                       02/01/2007
    RKS: Changed project name to Xymon                   02/10/2009
                                                                      */
arg lib .
if lib='' then
  lib='prd2.config'
init='0'             /*  Init flag  */
call ASSGN 'STDOUT','SYSLST'
/*  Set default values in case none are in the configuration member.  */
disk.yellow=90
disk.red=95
/*  Retrieve options member from lib                             */
'execio * diskr 'lib'.hobvars.z (stem hobvars. finis'
/*  Go through options table to fill values to run the client    */
j=1
do i=1 to hobvars.0
  if left(hobvars.i,1)='#' then iterate   /* Ignore comment */
  parse var hobvars.i kw therest
  select
    when kw='DISK' then do
      parse var therest type val1 val2 .
      if type='DEF' then do
        disk.yellow=val1
        disk.red=val2
        end
      else do
        hobdisk.j=therest /*  Pick up second value in DISK config     */
        j=j+1             /*  parameter, put into stem for processing */
        end
      end
    otherwise
      nop
    end
  end
hobdisk.0=j-1
call do_disktest
return
 
do_disktest:
/*  Process VSAM catalog entries.  */
process='CAT'
do r=1 to hobdisk.0
  parse upper var hobdisk.r type '=' value yelpct redpct .
  if type=process then
    call process_vsam_catalog value
  end
/*  Process VSE volume entries.  */
process='VOL'
do r=1 to hobdisk.0
  parse upper var hobdisk.r type '=' value yelpct redpct .
  if type=process then
    call process_vse_volume value
  end
/*  Process VSE library entries.  */
process='LIB'
do r=1 to hobdisk.0
  parse upper var hobdisk.r type '=' value yelpct redpct .
  if type=process then
    call process_vse_lib value
  end
return
 
process_vsam_catalog:
arg catname
parse var catname fileid '/' catname
cat_proc_error=0
call outtrap lst.
call rexxipt sysipt.
sysipt.0=1
sysipt.1=' LISTCAT CATALOG('CATNAME') SPACE ALL'
address link 'IDCAMS'
if rc<>0 then
  cat_proc_error=1
eof=0
end_of_vol=0
first=1
i=0
v=0
pc=0
do until eof
  call get_next_line
  if eof=1 then
    iterate
  select
    when word1='VOLUME' & left(word2,1)='-' then do
      call process_vsam_volume
      end
    otherwise
      nop
    end
  end
/* If individual percentage test is provided, use it.
   Otherwise use the default.                                */
if yelpct='' then
  yelpct=disk.yellow
if redpct='' then
  redpct=disk.red
out='C 'yelpct' 'redpct' 'fileid' 'catname' 'vs.v.dtyp' 'cat_proc_error
push out
'execio 1 diskw 'lib'.hobdskrs.z'
if cat_proc_error=1 then  /* Don't try to continue if catalog error */
  return
do v=1 to vs.numvols
  do ds=1 to vs.v.dspaces
    pct=((vs.v.ds.used / vs.v.ds.total) * 100)
    pct=format(pct,3,2)
    out='VV 'vs.v.volume' 'vs.v.ds.total' 'vs.v.ds.used ,
        vs.v.ds.numdsets' 'vs.v.ds.sdspace' 'pct' 'vs.v.ds.ucat
    push out
    'execio 1 diskw 'lib'.hobdskrs.z'
    end
  end
return
 
process_vse_volume:
arg volumeid
signal on error name vse_vol_error
call DITSETUP
address 'DITTO' '$SET HEADERPG=NO,PRINTOUT=REXX'
address 'DITTO' '$DVT INPUT=V'volumeid',SORTBY=EXTENT'
eof=0
marker_found=0
q=0
do until marker_found | eof
  q=q+1
  if q > ditto.0 then do
    say 'Ditto marker not found for' volumeid'.'
    eof=1
    end
  if left(ditto.q,3)='* *' then do
    marker_found=1
    parse var ditto.q 'Device' devno ',' . devtyp . cap . tpc .
    if devtyp='FBA' | devtyp='9336' then
      nop
    else
      cap=cap*tpc
    end
  end
back1=ditto.0-1
parse var ditto.back1 . . . . . . . . . left .
used=cap-left
pct=(used / cap) * 100
pct=format(pct,3,2)
/* If individual percentage test is provided, use it.
   Otherwise use the default.                                */
if yelpct='' then
  yelpct=disk.yellow
if redpct='' then
  redpct=disk.red
out='V 'yelpct' 'redpct' 'volumeid' 'devno' 'devtyp' 'cap' 'used' 'pct
push out
'execio 1 diskw 'lib'.hobdskrs.z'
drop ditto.
return
 
process_vse_lib:
arg libname
signal on error name error_out
call outtrap lst.
call rexxipt sysipt.
sysipt.0=1
sysipt.1=' LD L='libname' OUT=STAT'
address link 'LIBR'
eof=0
do q=1 to lst.0
  parse var lst.q libr_hdr ':' libr_value
  libr_hdr=strip(libr_hdr)
  libr_value=strip(libr_value)
  select
    when libr_hdr='FILE-ID' then
      file_id=libr_value
    when libr_hdr='SUBLIBRARIES' then
      sublibs=libr_value
    when libr_hdr='TOTAL   SPACE' then
      parse var libr_value totspace .
    when libr_hdr='USED    SPACE' then
      parse var libr_value usdspace .
    when libr_hdr='DELAYED SPACE' then
      parse var libr_value delayspace .
    when libr_hdr='FREE    SPACE' then
      parse var libr_value freespc .
    otherwise
      nop
    end
  end
pct=(usdspace / totspace) * 100
pct=format(pct,3,2)
/* If individual percentage test is provided, use it.
   Otherwise use the default.                                */
if yelpct='' then
  yelpct=disk.yellow
if redpct='' then
  redpct=disk.red
out='L 'yelpct' 'redpct' 'libname' 'sublibs' 'totspace' 'usdspace ,
    delayspace' 'pct
push out
'execio 1 diskw 'lib'.hobdskrs.z'
drop lst.
return
 
process_vsam_volume:
parse var lst.i . . volid
end_of_vol=0
ds=0
v=v+1
vs.numvols=v
vs.v.volume=volid
do until eof | end_of_vol
  call get_next_line
  select
    when word1='CHARACTERISTICS' then do
      call process_char
      end
    when word1='DATASPACE' then do
      call process_ds
/*  At the end of DATASPACE processing if a new VOLUME comes up, we
    need to detect it and back up the pointer so that the normal volume
    logic can pick it up.                                       */
      if word1='VOLUME' then do
        i=i-1
        end_of_vol=1
        end
      end
    when word1='VOLUME' then do  /* If we find VOLUME here backup  */
      i=i-1
      end_of_vol=1
      end
    otherwise
      nop
    end
  end
return
 
process_char:
call get_next_line
parse var lst.i . devtyp .
call get_next_line
call get_next_line
tdevtyp=translate(devtyp,' ','-')
parse var tdevtyp . ddevtyp
ddevtyp=space(strip(ddevtyp),0)
vs.v.dtyp=ddevtyp
return
 
process_ds:
usercat=0
end_of_ds=0
do until end_of_ds
  call get_next_line
  att=word(lst.i,words(lst.i))
  if att='USERCAT' then do
    usercat=1
    end
  if left(word1,8)='DATASETS' then do
    tnumdsets=translate(word1,' ','-')
    parse var tnumdsets . dnumdsets
    end
  if word1='EXTENT-DESCRIPTOR:' then do
    ds=ds+1
    do until word1='DATASET-DIRECTORY:' | word1='VOLUME' | eof
      call get_next_line
      check=left(word1,12)
      if check='TRACKS-TOTAL' | check='BLOCKS-TOTAL' | ,
            check='CYL-TOTAL---' then do
        parse var lst.i trackstotal .
        ttrackstotal=translate(trackstotal,' ','-')
        parse var ttrackstotal . . dtrackstotal
        end
      check=left(word1,11)
      if check='TRACKS-USED' | check='BLOCKS-USED' | ,
            check='CYL-USED---' then do
        parse var lst.i tracksused .
        ttracksused=translate(tracksused,' ','-')
        parse var ttracksused . . dtracksused
        end
      check=left(word2,8)
      if check='BEG-CCHH' then do
        parse var lst.i . begdspace .
        tbegdspace=translate(begdspace,' ','-')
        parse var tbegdspace . . dbegdspace
        parse var tbegdspace "'" startdspace "'"
        startdspace=right(startdspace,9)
        end
      if check='BEG-BLOC' then do
        parse var lst.i . begdspace .
        tbegdspace=translate(begdspace,' ','-')
        parse var tbegdspace . . startdspace
        startdspace=format(startdspace,9,0)
        end
      end
    end_of_ds=1
    vs.v.dspaces=ds
    vs.v.ds.ucat=usercat
    vs.v.ds.total=dtrackstotal
    vs.v.ds.used=dtracksused
    vs.v.ds.sdspace=startdspace
    vs.v.ds.numdsets=dnumdsets
    end
  end
return
 
get_next_line:
i=i+1
parse var lst.i word1 word2 .
if word1='IDCAMS' | word1='LISTING' | word1='' then do
  do until word1<>'IDCAMS' & word1<>'LISTING' & word1<>''
    i=i+1
    parse var lst.i word1 word2 .
    end
  end
if word1='THE' & word2='NUMBER' then do  /* Check for end of LSTCAT */
  eof=1
  end
return
 
write_line:
'execio 1 diskw syslst (cc stem line.'
lc=lc+1
if lc>60 then
  call print_heading
return
 
error_out:
exit
 
vse_vol_error:
say 'Error accessing' volumeid'.'
exit
