/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.text.Segment;
import processing.app.Editor;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.SyntaxStyle;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.Token;
import processing.app.syntax.TokenMarker;
import processing.core.PApplet;

public class DiscourseFormat {
    Editor editor;
    JEditTextArea textarea;
    boolean html;

    public DiscourseFormat(Editor editor, boolean bl) {
        this.editor = editor;
        this.textarea = editor.getTextArea();
        this.html = bl;
    }

    public void show() {
        StringBuffer stringBuffer = new StringBuffer(this.html ? "<pre>\n" : "[quote]\n");
        int n = this.textarea.getSelectionStart();
        int n2 = this.textarea.getSelectionStop();
        int n3 = this.textarea.getSelectionStartLine();
        int n4 = this.textarea.getSelectionStopLine();
        if (n == n2) {
            n3 = 0;
            n4 = this.textarea.getLineCount() - 1;
        } else if (this.textarea.getLineStartOffset(n4) == n2) {
            --n4;
        }
        for (int i = n3; i <= n4; ++i) {
            this.appendFormattedLine(stringBuffer, i);
        }
        stringBuffer.append(this.html ? "\n</pre>" : "\n[/quote]");
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, new ClipboardOwner(){

            public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            }
        });
        this.editor.statusNotice("Code formatted for " + (this.html ? "HTML" : "the Arduino forum ") + " has been copied to the clipboard.");
    }

    public void appendFormattedLine(StringBuffer stringBuffer, int n) {
        Segment segment = new Segment();
        TextAreaPainter textAreaPainter = this.textarea.getPainter();
        TokenMarker tokenMarker = this.textarea.getTokenMarker();
        this.textarea.getLineText(n, segment);
        char[] cArray = segment.array;
        int n2 = segment.getEndIndex();
        int n3 = segment.offset;
        int n4 = segment.count;
        if (tokenMarker == null) {
            for (int i = 0; i < n4; ++i) {
                char c = cArray[i + n3];
                stringBuffer = stringBuffer.append(c);
            }
        } else {
            Token token;
            if (textAreaPainter.getCurrentLineIndex() == n && textAreaPainter.getCurrentLineTokens() != null) {
                token = textAreaPainter.getCurrentLineTokens();
            } else {
                textAreaPainter.setCurrentLineIndex(n);
                textAreaPainter.setCurrentLineTokens(tokenMarker.markTokens(segment, n));
                token = textAreaPainter.getCurrentLineTokens();
            }
            int n5 = 0;
            SyntaxStyle[] syntaxStyleArray = textAreaPainter.getStyles();
            while (true) {
                int n6;
                byte by;
                if ((by = token.id) == 127) {
                    n6 = cArray[n3 + n5];
                    if (n3 + n5 < n2) {
                        stringBuffer.append((char)n6);
                    } else {
                        stringBuffer.append('\n');
                    }
                    return;
                }
                if (by != 0) {
                    stringBuffer.append(this.html ? "<span style=\"color: #" : "[color=#");
                    stringBuffer.append(PApplet.hex((int)(syntaxStyleArray[by].getColor().getRGB() & 0xFFFFFF), (int)6));
                    stringBuffer.append(this.html ? ";\">" : "]");
                    if (syntaxStyleArray[by].isBold()) {
                        stringBuffer.append(this.html ? "<b>" : "[b]");
                    }
                }
                n6 = token.length;
                for (int i = 0; i < n6; ++i) {
                    char c = cArray[n3 + n5 + i];
                    if (n5 == 0 && c == ' ') {
                        stringBuffer.append(this.html ? "&nbsp;" : Character.valueOf('\u00a0'));
                    } else {
                        stringBuffer.append(c);
                    }
                    if (i == n6 - '\u0001' && by != 0 && syntaxStyleArray[by].isBold()) {
                        stringBuffer.append(this.html ? "</b>" : "[/b]");
                    }
                    if (i != n6 - '\u0001' || by == 0) continue;
                    stringBuffer.append(this.html ? "</span>" : "[/color]");
                }
                n5 += n6;
                token = token.next;
            }
        }
    }
}

