/*
 * Decompiled with CFR 0.152.
 */
package org.treebind.tests;

import java.io.DataInputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.TestCase;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.LDIF;
import org.apache.xml.serialize.XMLSerializer;
import org.treebind.JavaClassName;
import org.treebind.JavaMethodName;
import org.treebind.JavaObject2XmlSaxPipe;
import org.treebind.JavaObjectSink;
import org.treebind.JavaObjectSource;
import org.treebind.JenaRdf2JavaObjectPipe;
import org.treebind.JenaRdfSource;
import org.treebind.Ldap2JavaObjectPipe;
import org.treebind.Ldap2XmlSaxPipe;
import org.treebind.TraceSink;
import org.treebind.XmlAttributeName;
import org.treebind.XmlElementName;
import org.treebind.XmlProductionName;
import org.treebind.XmlSax2JavaObjectPipe;
import org.treebind.XmlSaxSink;
import org.treebind.XmlSaxSource;
import org.treebind.tests.Author;
import org.treebind.tests.Book;
import org.treebind.tests.Foo;
import org.treebind.tests.Person;
import org.treebind.tests.SimpleContentComplexType;
import org.xml.sax.ContentHandler;

public class Test
extends TestCase {
    public void testXmlSaxSink1() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        sink.addLeaf(null, new XmlElementName("", "foo"), "bar");
        Test.assertEquals((String)"<?xml version=\"1.0\"?>\n<foo>bar</foo>", (String)writer.toString());
    }

    public void testXmlSaxSink2() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        sink.addLeaf(null, new XmlElementName("http://treebind.org", "foo"), "bar");
        Test.assertEquals((String)writer.toString(), (String)"<?xml version=\"1.0\"?>\n<foo xmlns=\"http://treebind.org\">bar</foo>");
    }

    public void testXmlSaxSink3() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        sink.startProperty(null, new XmlElementName("", "foo"));
        sink.addLeaf(null, new XmlElementName("", "bar"), "bat");
        sink.endProperty();
        Test.assertEquals((String)writer.toString(), (String)"<?xml version=\"1.0\"?>\n<foo><bar>bat</bar></foo>");
    }

    public void testXmlSaxSink4() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        sink.startProperty(null, new XmlElementName("http://treebind.org", "foo"));
        sink.addLeaf(null, new XmlElementName("http://treebind.org", "bar"), "bat");
        sink.endProperty();
        Test.assertEquals((String)writer.toString(), (String)"<?xml version=\"1.0\"?>\n<foo xmlns=\"http://treebind.org\"><bar>bat</bar></foo>");
    }

    public void testXmlSaxSink5() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        sink.startProperty(null, new XmlElementName("http://treebind.org", "foo"));
        sink.addLeaf(null, new XmlElementName("", "bar"), "bat");
        sink.endProperty();
        Test.assertEquals((String)writer.toString(), (String)"<?xml version=\"1.0\"?>\n<foo xmlns=\"http://treebind.org\"><bar xmlns=\"\">bat</bar></foo>");
    }

    public void testXmlSaxSink6() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        sink.startProperty(null, new XmlElementName("", "foo"));
        sink.addLeaf(null, new XmlAttributeName("", "", "bar"), "bat");
        sink.addLeaf(null, XmlProductionName.TEXTNODE, "value");
        sink.endProperty();
        Test.assertEquals((String)writer.toString(), (String)"<?xml version=\"1.0\"?>\n<foo bar=\"bat\">value</foo>");
    }

    public void testJavaObjectSink1() throws Throwable {
        JavaObjectSink sink = new JavaObjectSink();
        sink.addLeaf(new JavaClassName("org.treebind.whatever.Whatever"), new JavaClassName("org.treebind.whatever.Whatever"), "foo");
        Object object = sink.getObject();
        Test.assertEquals((String)object.getClass().getName(), (String)"java.lang.String");
        Test.assertEquals((Object)object, (Object)"foo");
    }

    public void testJavaObjectSink2() throws Throwable {
        JavaObjectSink sink = new JavaObjectSink();
        sink.startProperty(new JavaMethodName("Book"), new JavaClassName("org.treebind.tests.Book"));
        sink.addLeaf(new JavaMethodName("Title"), new JavaClassName("org.treebind.whatever.Title"), "RELAX NG");
        sink.endProperty();
        Object object = sink.getObject();
        Test.assertEquals((String)"org.treebind.tests.Book", (String)object.getClass().getName());
        Book book = (Book)object;
        Test.assertEquals((String)"RELAX NG", (String)book.getTitle());
    }

    public void testJavaObjectSink3() throws Throwable {
        JavaObjectSink sink = new JavaObjectSink();
        sink.startProperty(new JavaMethodName("Book"), new JavaClassName("org.treebind.tests.Book"));
        sink.addLeaf(new JavaMethodName("Title"), new JavaClassName("org.treebind.whatever.Title"), "RELAX NG");
        sink.startProperty(new JavaMethodName("Author"), new JavaClassName("org.treebind.tests.Author"));
        sink.addLeaf(new JavaMethodName("Fname"), new JavaClassName("org.treebind.whatever.Fname"), "Eric");
        sink.addLeaf(new JavaClassName("org.treebind.whatever.Lname"), new JavaClassName("org.treebind.whatever.Lname"), "van der Vlist");
        sink.endProperty();
        sink.endProperty();
        Object object = sink.getObject();
        Test.assertEquals((String)"org.treebind.tests.Book", (String)object.getClass().getName());
        Book book = (Book)object;
        Test.assertEquals((String)"RELAX NG", (String)book.getTitle());
        Person author = book.getAuthor();
        Test.assertEquals((String)"Eric", (String)author.getFname());
        Test.assertEquals((String)"van der Vlist", (String)author.getLname());
    }

    public void testJavaObjectSink4() throws Throwable {
        JavaObjectSink sink = new JavaObjectSink();
        sink.startProperty(new JavaClassName("org.treebind.tests.Book"), new JavaClassName("org.treebind.tests.Book"));
        sink.addLeaf(new JavaClassName("org.treebind.whatever.Comment"), new JavaClassName("org.treebind.whatever.Comment"), "Great");
        sink.addLeaf(new JavaClassName("org.treebind.whatever.Comment"), new JavaClassName("org.treebind.whatever.Comment"), "Horrible");
        sink.endProperty();
        Object object = sink.getObject();
        Test.assertEquals((String)"org.treebind.tests.Book", (String)object.getClass().getName());
        Book book = (Book)object;
        Iterator iterator = book.getComments();
        String comment = (String)iterator.next();
        Test.assertEquals((String)"Great", (String)comment);
        comment = (String)iterator.next();
        Test.assertEquals((String)"Horrible", (String)comment);
        Test.assertEquals((boolean)false, (boolean)iterator.hasNext());
    }

    public void testXml2Xml1() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        XmlSaxSource source = new XmlSaxSource();
        source.setSink(sink);
        String xml = "<?xml version=\"1.0\"?>\n<foo xmlns=\"http://treebind.org\"><bar>bat</bar></foo>";
        source.parseString(xml);
        Test.assertEquals((String)xml, (String)writer.toString());
    }

    public void testXml2Xml2() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        XmlSaxSource source = new XmlSaxSource();
        source.setSink(sink);
        String xml = "<?xml version=\"1.0\"?>\n<book><title>RELAX NG</title><author><fname>Eric</fname><lname>van der Vlist</lname></author></book>";
        source.parseString(xml);
        Test.assertEquals((String)xml, (String)writer.toString());
    }

    public void testXml2Xml3() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        XmlSaxSource source = new XmlSaxSource();
        source.setSink(sink);
        String xml = "<?xml version=\"1.0\"?>\n<book title=\"RELAX NG\"><author><fname>Eric</fname><lname>van der Vlist</lname></author></book>";
        source.parseString(xml);
        Test.assertEquals((String)xml, (String)writer.toString());
    }

    public void testXml2Xml4() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        XmlSaxSource source = new XmlSaxSource();
        source.setSink(sink);
        String xml = "<?xml version=\"1.0\"?>\n<book title=\"RELAX NG\" xmlns=\"http://treebind.org\"><author><fname>Eric</fname><lname>van der Vlist</lname></author></book>";
        source.parseString(xml);
        Test.assertEquals((String)xml, (String)writer.toString());
    }

    public void testXml2Xml5() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        XmlSaxSource source = new XmlSaxSource();
        source.setSink(sink);
        String xml = "<?xml version=\"1.0\"?>\n<foo bar=\"bat\">value</foo>";
        source.parseString(xml);
        Test.assertEquals((String)xml, (String)writer.toString());
    }

    public void testObjectRaw2Xml1() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        JavaObjectSource source = new JavaObjectSource();
        source.setSink(sink);
        Book book = new Book();
        book.setTitle("XML Schema");
        Author author = new Author();
        author.setFname("Eric");
        author.setLname("van der Vlist");
        book.setAuthor(author);
        source.pourObject(book);
        String xml = "<?xml version=\"1.0\"?>\n<Book xmlns=\"org.treebind.tests\"><String xmlns=\"java.lang\">XML Schema</String><Author><String xmlns=\"java.lang\">Eric</String><String xmlns=\"java.lang\">van der Vlist</String></Author></Book>";
        Test.assertEquals((String)xml, (String)writer.toString());
    }

    public void testObjectRaw2Xml2() throws Throwable {
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        XmlSaxSink sink = new XmlSaxSink();
        sink.setContentHandler((ContentHandler)contentHandler);
        JavaObjectSource source = new JavaObjectSource();
        source.setSink(sink);
        Book book = new Book();
        book.addComment("Great");
        book.addComment("Stupid");
        source.pourObject(book);
        String xml = "<?xml version=\"1.0\"?>\n<Book xmlns=\"org.treebind.tests\"><String xmlns=\"java.lang\">Great</String><String xmlns=\"java.lang\">Stupid</String></Book>";
        Test.assertEquals((String)xml, (String)writer.toString());
    }

    public void testXmlSax2JavaObjectPipe1() throws Throwable {
        XmlSax2JavaObjectPipe pipe = new XmlSax2JavaObjectPipe();
        pipe.setParameter("namespace2package", "", "org.treebind.tests");
        String xml = "<?xml version=\"1.0\"?>\n<book><title>RELAX NG</title><author><fname>Eric</fname><lname>van der Vlist</lname></author><comment>Great</comment><comment>Horrible</comment></book>";
        pipe.parseString(xml);
        Object object = pipe.getObject();
        Test.assertEquals((String)"org.treebind.tests.Book", (String)object.getClass().getName());
        Book book = (Book)object;
        Test.assertEquals((String)"RELAX NG", (String)book.getTitle());
        Person author = book.getAuthor();
        Test.assertEquals((String)"Eric", (String)author.getFname());
        Test.assertEquals((String)"van der Vlist", (String)author.getLname());
        Iterator iterator = book.getComments();
        String comment = (String)iterator.next();
        Test.assertEquals((String)"Great", (String)comment);
        comment = (String)iterator.next();
        Test.assertEquals((String)"Horrible", (String)comment);
        Test.assertEquals((boolean)false, (boolean)iterator.hasNext());
    }

    public void testXmlSax2JavaObjectPipe2() throws Throwable {
        XmlSax2JavaObjectPipe pipe = new XmlSax2JavaObjectPipe();
        pipe.setParameter("namespace2package", "", "org.treebind.tests");
        String xml = "<?xml version=\"1.0\"?>\n<simpleContentComplexType attribute='attribute value'>element value</simpleContentComplexType>";
        pipe.parseString(xml);
        Object object = pipe.getObject();
        Test.assertEquals((String)"org.treebind.tests.SimpleContentComplexType", (String)object.getClass().getName());
        SimpleContentComplexType simpleContentComplexType = (SimpleContentComplexType)object;
        Test.assertEquals((String)"attribute value", (String)simpleContentComplexType.getAttribute());
        Test.assertEquals((String)"element value", (String)simpleContentComplexType.getValue());
    }

    public void testJavaObject2XmlSaxPipe1() throws Throwable {
        JavaObject2XmlSaxPipe pipe = new JavaObject2XmlSaxPipe();
        pipe.setParameter("package2namespace", "org.treebind.tests", "");
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        pipe.setContentHandler((ContentHandler)contentHandler);
        Book book = new Book();
        book.setTitle("XML Schema");
        Author author = new Author();
        author.setFname("Eric");
        author.setLname("van der Vlist");
        book.setAuthor(author);
        book.addComment("Great");
        book.addComment("Stupid");
        pipe.pourObject(book);
        String xml = "<?xml version=\"1.0\"?>\n<book><title>XML Schema</title><author><fname>Eric</fname><lname>van der Vlist</lname></author><comment>Great</comment><comment>Stupid</comment></book>";
        Test.assertEquals((String)xml, (String)writer.toString());
    }

    void testRoundTrip(String xml, String namespace) throws Throwable {
        XmlSax2JavaObjectPipe pipe1 = new XmlSax2JavaObjectPipe();
        pipe1.setParameter("namespace2package", namespace, "org.treebind.tests");
        pipe1.parseString(xml);
        Object o = pipe1.getObject();
        JavaObject2XmlSaxPipe pipe2 = new JavaObject2XmlSaxPipe();
        pipe2.setParameter("package2namespace", "org.treebind.tests", namespace);
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        pipe2.setContentHandler((ContentHandler)contentHandler);
        pipe2.pourObject(o);
        String res = writer.toString();
        System.out.println(res);
        Test.assertEquals((String)xml, (String)res);
    }

    void testRoundTrip(String xml) throws Throwable {
        this.testRoundTrip(xml, "");
    }

    public void testSerializeFoo1bis() throws Throwable {
        this.testRoundTrip("<?xml version=\"1.0\"?>\n<foo><bar></bar></foo>");
    }

    public void testSerializeFoo2() throws Throwable {
        this.testRoundTrip("<?xml version=\"1.0\"?>\n<foo><bar>barValue</bar></foo>");
    }

    public void testSerializeFoo3() throws Throwable {
        this.testRoundTrip("<?xml version=\"1.0\"?>\n<foo><simpleContentComplexType>value<attribute>att</attribute></simpleContentComplexType></foo>");
    }

    public void testSerializeBook() throws Throwable {
        this.testRoundTrip("<?xml version=\"1.0\"?>\n<book><title>XML Schema</title><author><fname>Eric</fname><lname>van der Vlist</lname></author><comment>Great</comment><comment>Stupid</comment></book>");
    }

    public void testRdfSource1() throws Throwable {
        TraceSink sink = new TraceSink();
        JenaRdfSource source = new JenaRdfSource();
        String rdfString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF xmlns=\"http://treebind.org/ns/example/\"    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">    <book>        <title>RELAX NG</title>        <author rdf:resource=\"#vdv\"/>    </book>    <person rdf:ID=\"vdv\">        <fname>Eric</fname>        <lname>van der Vlist</lname>    </person></rdf:RDF>";
        source.parseString(rdfString);
        source.setSink(sink);
        source.pourModelFromType("http://treebind.org/ns/example/book");
        String result = "startProperty(class org.treebind.Names(root), class org.treebind.RdfResourceName(http://treebind.org/ns/example/book))\nstartProperty(class org.treebind.RdfResourceName(http://www.w3.org/1999/02/22-rdf-syntax-ns#type), class org.treebind.RdfResourceName(http://www.w3.org/1999/02/22-rdf-syntax-ns#type))\naddLeaf(class org.treebind.RdfResourceName(http://treebind.org/ns/uri), class org.treebind.Names(literal), http://treebind.org/ns/example/book)\nendProperty()\nstartProperty(class org.treebind.RdfResourceName(http://treebind.org/ns/example/author), class org.treebind.RdfResourceName(http://treebind.org/ns/example/person))\naddLeaf(class org.treebind.RdfResourceName(http://treebind.org/ns/uri), class org.treebind.Names(literal), http://treebind.org/defaultBase/#vdv)\nstartProperty(class org.treebind.RdfResourceName(http://www.w3.org/1999/02/22-rdf-syntax-ns#type), class org.treebind.RdfResourceName(http://www.w3.org/1999/02/22-rdf-syntax-ns#type))\naddLeaf(class org.treebind.RdfResourceName(http://treebind.org/ns/uri), class org.treebind.Names(literal), http://treebind.org/ns/example/person)\nendProperty()\naddLeaf(class org.treebind.RdfResourceName(http://treebind.org/ns/example/fname), class org.treebind.Names(literal), Eric)\naddLeaf(class org.treebind.RdfResourceName(http://treebind.org/ns/example/lname), class org.treebind.Names(literal), van der Vlist)\nendProperty()\naddLeaf(class org.treebind.RdfResourceName(http://treebind.org/ns/example/title), class org.treebind.Names(literal), RELAX NG)\nendProperty()\n";
        Test.assertEquals((String)result, (String)sink.toString());
    }

    public void testRdfPipe2Object1() throws Throwable {
        JenaRdf2JavaObjectPipe pipe = new JenaRdf2JavaObjectPipe();
        pipe.setParameter("namespace2package", "http://treebind.org/ns/example/", "org.treebind.tests");
        String rdfString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF xmlns=\"http://treebind.org/ns/example/\"    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">    <book>        <title>RELAX NG</title>        <author rdf:resource=\"#vdv\"/>        <comment>Good</comment>        <comment>Bad</comment>    </book>    <person rdf:ID=\"vdv\">        <fname>Eric</fname>        <lname>van der Vlist</lname>    </person></rdf:RDF>";
        pipe.parseString(rdfString);
        pipe.pourModelFromType("http://treebind.org/ns/example/book");
        Object object = pipe.getObject();
        Test.assertEquals((String)"org.treebind.tests.Book", (String)object.getClass().getName());
        Book book = (Book)object;
        Test.assertEquals((String)"RELAX NG", (String)book.getTitle());
        Person author = book.getAuthor();
        Test.assertEquals((String)"Eric", (String)author.getFname());
        Test.assertEquals((String)"van der Vlist", (String)author.getLname());
        Iterator iterator = book.getComments();
        String comment = (String)iterator.next();
        Test.assertEquals((String)"Good", (String)comment);
        comment = (String)iterator.next();
        Test.assertEquals((String)"Bad", (String)comment);
        Test.assertEquals((boolean)false, (boolean)iterator.hasNext());
    }

    public void testRdfPipe2Object2() throws Throwable {
        JenaRdf2JavaObjectPipe pipe = new JenaRdf2JavaObjectPipe();
        pipe.setParameter("namespace2package", "http://treebind.org/ns/example/", "org.treebind.tests");
        pipe.setParameter("namespace2class", "http://treebind.org/ns/example/", "org.treebind.tests.Author");
        String rdfString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rdf:RDF xmlns=\"http://treebind.org/ns/example/\"    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">    <book>        <title>RELAX NG</title>        <author rdf:resource=\"#vdv\"/>        <comment>Good</comment>        <comment>Bad</comment>    </book>    <doesntExist rdf:ID=\"vdv\">        <fname>Eric</fname>        <lname>van der Vlist</lname>    </doesntExist></rdf:RDF>";
        pipe.parseString(rdfString);
        pipe.pourModelFromType("http://treebind.org/ns/example/book");
        Object object = pipe.getObject();
        Test.assertEquals((String)"org.treebind.tests.Book", (String)object.getClass().getName());
        Book book = (Book)object;
        Test.assertEquals((String)"RELAX NG", (String)book.getTitle());
        Person author = book.getAuthor();
        Test.assertEquals((String)"Eric", (String)author.getFname());
        Test.assertEquals((String)"van der Vlist", (String)author.getLname());
    }

    public void testLdap2XmlSax1() throws Throwable {
        Ldap2XmlSaxPipe pipe = new Ldap2XmlSaxPipe();
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        pipe.setContentHandler((ContentHandler)contentHandler);
        LDAPConnection ld = null;
        ld = new LDAPConnection();
        String MY_HOST = "localhost";
        int MY_PORT = 389;
        ld.connect(MY_HOST, MY_PORT);
        String[] attrNames = new String[]{"*"};
        LDAPSearchResults res = ld.search("dc=dyomedea,dc=com", 2, "(&(objectClass=InetOrgPerson)(Uid=fred))", attrNames, false);
        pipe.pour(res);
        String xml = writer.toString();
        Test.assertEquals((String)"<?xml version=\"1.0\"?>\n<ldapSearchResultsElement><ldapEntry><ldapDN>uid=fred,ou=Users,dc=dyomedea,dc=com</ldapDN><objectClass>top</objectClass><objectClass>inetOrgPerson</objectClass><objectClass>posixAccount</objectClass><objectClass>shadowAccount</objectClass><objectClass>sambaSAMAccount</objectClass><objectClass>inetLocalMailRecipient</objectClass><cn>Fred Bloggs</cn><sn>fred</sn><uid>fred</uid><uidNumber>1001</uidNumber><gidNumber>513</gidNumber><homeDirectory>/home/fred</homeDirectory><loginShell>/bin/bash</loginShell><gecos>Fred Bloggs</gecos><description>Fred Bloggs</description><sambaLogonTime>0</sambaLogonTime><sambaLogoffTime>2147483647</sambaLogoffTime><sambaKickoffTime>2147483647</sambaKickoffTime><sambaPwdCanChange>0</sambaPwdCanChange><sambaPwdMustChange>2147483647</sambaPwdMustChange><displayName>Fred Bloggs</displayName><sambaAcctFlags>[UX]</sambaAcctFlags><sambaSID>S-1-5-21-4178977412-3634974517-1988995060-3002</sambaSID><sambaLogonScript>fred.cmd</sambaLogonScript><sambaProfilePath>\\\\PDC-SMB3\\profiles\\fred</sambaProfilePath><sambaHomePath>\\\\PDC-SMB3\\homes\\fred</sambaHomePath><sambaPrimaryGroupSID>S-1-5-21-4178977412-3634974517-1988995060-513</sambaPrimaryGroupSID><sambaHomeDrive>H:</sambaHomeDrive><mailLocalAddress>fred.bloggs</mailLocalAddress><mail>fred.bloggs@dyomedea.com</mail><sambaPwdLastSet>1129147868</sambaPwdLastSet></ldapEntry></ldapSearchResultsElement>", (String)xml);
    }

    public void testLdap2XmlSax2() throws Throwable {
        Ldap2XmlSaxPipe pipe = new Ldap2XmlSaxPipe();
        pipe.setParameter("ldapSearchResultsElement", "http://www.w3.org/1999/02/22-rdf-syntax-ns#RDF");
        pipe.setParameter("ldapEntry", "http://xml.insee.fr/schema/ldap/annuaire/inseePerson");
        pipe.setParameter("defaultLdapNamespace", "http://xml.insee.fr/schema/ldap/annuaire/");
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        pipe.setContentHandler((ContentHandler)contentHandler);
        LDAPConnection ld = null;
        ld = new LDAPConnection();
        String MY_HOST = "localhost";
        int MY_PORT = 389;
        ld.connect(MY_HOST, MY_PORT);
        String[] attrNames = new String[]{"*"};
        LDAPSearchResults res = ld.search("dc=dyomedea,dc=com", 2, "(&(objectClass=InetOrgPerson)(Uid=fred))", attrNames, false);
        pipe.pour(res);
        String xml = writer.toString();
        System.out.println(xml);
        Test.assertEquals((String)"<?xml version=\"1.0\"?>\n<RDF xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><inseePerson xmlns=\"http://xml.insee.fr/schema/ldap/annuaire/\"><ldapDN>uid=fred,ou=Users,dc=dyomedea,dc=com</ldapDN><objectClass>top</objectClass><objectClass>inetOrgPerson</objectClass><objectClass>posixAccount</objectClass><objectClass>shadowAccount</objectClass><objectClass>sambaSAMAccount</objectClass><objectClass>inetLocalMailRecipient</objectClass><cn>Fred Bloggs</cn><sn>fred</sn><uid>fred</uid><uidNumber>1001</uidNumber><gidNumber>513</gidNumber><homeDirectory>/home/fred</homeDirectory><loginShell>/bin/bash</loginShell><gecos>Fred Bloggs</gecos><description>Fred Bloggs</description><sambaLogonTime>0</sambaLogonTime><sambaLogoffTime>2147483647</sambaLogoffTime><sambaKickoffTime>2147483647</sambaKickoffTime><sambaPwdCanChange>0</sambaPwdCanChange><sambaPwdMustChange>2147483647</sambaPwdMustChange><displayName>Fred Bloggs</displayName><sambaAcctFlags>[UX]</sambaAcctFlags><sambaSID>S-1-5-21-4178977412-3634974517-1988995060-3002</sambaSID><sambaLogonScript>fred.cmd</sambaLogonScript><sambaProfilePath>\\\\PDC-SMB3\\profiles\\fred</sambaProfilePath><sambaHomePath>\\\\PDC-SMB3\\homes\\fred</sambaHomePath><sambaPrimaryGroupSID>S-1-5-21-4178977412-3634974517-1988995060-513</sambaPrimaryGroupSID><sambaHomeDrive>H:</sambaHomeDrive><mailLocalAddress>fred.bloggs</mailLocalAddress><mail>fred.bloggs@dyomedea.com</mail><sambaPwdLastSet>1129147868</sambaPwdLastSet></inseePerson></RDF>", (String)xml);
    }

    public void testLdap2XmlSax3() throws Throwable {
        Ldap2XmlSaxPipe pipe = new Ldap2XmlSaxPipe();
        pipe.setParameter("ldapSearchResultsElement", "http://www.w3.org/1999/02/22-rdf-syntax-ns#RDF");
        pipe.setParameter("ldapEntry", "http://xml.insee.fr/schema/ldap/annuaire/inseePerson");
        pipe.setParameter("defaultLdapNamespace", "http://xml.insee.fr/schema/ldap/annuaire/");
        pipe.setParameter("xmlns", "rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        pipe.setContentHandler((ContentHandler)contentHandler);
        LDAPConnection ld = null;
        ld = new LDAPConnection();
        String MY_HOST = "localhost";
        int MY_PORT = 389;
        ld.connect(MY_HOST, MY_PORT);
        String[] attrNames = new String[]{"*"};
        LDAPSearchResults res = ld.search("dc=dyomedea,dc=com", 2, "(&(objectClass=InetOrgPerson)(Uid=fred))", attrNames, false);
        pipe.pour(res);
        String xml = writer.toString();
        System.out.println(xml);
        Test.assertEquals((String)"<?xml version=\"1.0\"?>\n<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><inseePerson xmlns=\"http://xml.insee.fr/schema/ldap/annuaire/\"><ldapDN>uid=fred,ou=Users,dc=dyomedea,dc=com</ldapDN><objectClass>top</objectClass><objectClass>inetOrgPerson</objectClass><objectClass>posixAccount</objectClass><objectClass>shadowAccount</objectClass><objectClass>sambaSAMAccount</objectClass><objectClass>inetLocalMailRecipient</objectClass><cn>Fred Bloggs</cn><sn>fred</sn><uid>fred</uid><uidNumber>1001</uidNumber><gidNumber>513</gidNumber><homeDirectory>/home/fred</homeDirectory><loginShell>/bin/bash</loginShell><gecos>Fred Bloggs</gecos><description>Fred Bloggs</description><sambaLogonTime>0</sambaLogonTime><sambaLogoffTime>2147483647</sambaLogoffTime><sambaKickoffTime>2147483647</sambaKickoffTime><sambaPwdCanChange>0</sambaPwdCanChange><sambaPwdMustChange>2147483647</sambaPwdMustChange><displayName>Fred Bloggs</displayName><sambaAcctFlags>[UX]</sambaAcctFlags><sambaSID>S-1-5-21-4178977412-3634974517-1988995060-3002</sambaSID><sambaLogonScript>fred.cmd</sambaLogonScript><sambaProfilePath>\\\\PDC-SMB3\\profiles\\fred</sambaProfilePath><sambaHomePath>\\\\PDC-SMB3\\homes\\fred</sambaHomePath><sambaPrimaryGroupSID>S-1-5-21-4178977412-3634974517-1988995060-513</sambaPrimaryGroupSID><sambaHomeDrive>H:</sambaHomeDrive><mailLocalAddress>fred.bloggs</mailLocalAddress><mail>fred.bloggs@dyomedea.com</mail><sambaPwdLastSet>1129147868</sambaPwdLastSet></inseePerson></rdf:RDF>", (String)xml);
    }

    public void testLdif2XmlSax1() throws Throwable {
        Ldap2XmlSaxPipe pipe = new Ldap2XmlSaxPipe();
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        pipe.setContentHandler((ContentHandler)contentHandler);
        String ldifString = "# fred, Users, dyomedea.com\ndn: uid=fred,ou=Users,dc=dyomedea,dc=com\nobjectClass: top\nobjectClass: inetOrgPerson\nobjectClass: posixAccount\nobjectClass: shadowAccount\nobjectClass: sambaSAMAccount\nobjectClass: inetLocalMailRecipient\ncn: Fred Bloggs\nsn: fred\nuid: fred\nuidNumber: 1001\ngidNumber: 513\nsambaPwdLastSet: 1129147868\n";
        StringBufferInputStream is = new StringBufferInputStream(ldifString);
        DataInputStream stream = new DataInputStream(is);
        LDIF ldif = new LDIF(stream);
        pipe.pour(ldif);
        String xml = writer.toString();
        Test.assertEquals((String)"<?xml version=\"1.0\"?>\n<ldifElement><ldifRecord><ldapDN>uid=fred,ou=Users,dc=dyomedea,dc=com</ldapDN><objectclass>top</objectclass><objectclass>inetOrgPerson</objectclass><objectclass>posixAccount</objectclass><objectclass>shadowAccount</objectclass><objectclass>sambaSAMAccount</objectclass><objectclass>inetLocalMailRecipient</objectclass><gidnumber>513</gidnumber><uidnumber>1001</uidnumber><uid>fred</uid><sambapwdlastset>1129147868</sambapwdlastset><sn>fred</sn><cn>Fred Bloggs</cn></ldifRecord></ldifElement>", (String)xml);
    }

    public void testLdif2XmlSax2() throws Throwable {
        Ldap2XmlSaxPipe pipe = new Ldap2XmlSaxPipe();
        StringWriter writer = new StringWriter();
        XMLSerializer contentHandler = new XMLSerializer((Writer)writer, null);
        pipe.setParameter("ldifElement", "http://www.w3.org/1999/02/22-rdf-syntax-ns#RDF");
        pipe.setParameter("ldifRecord", "http://xml.insee.fr/schema/ldap/annuaire/inseePerson");
        pipe.setParameter("defaultLdapNamespace", "http://xml.insee.fr/schema/ldap/annuaire/");
        pipe.setParameter("xmlns", "rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        pipe.setContentHandler((ContentHandler)contentHandler);
        String ldifString = "# fred, Users, dyomedea.com\ndn: uid=fred,ou=Users,dc=dyomedea,dc=com\nobjectClass: top\nobjectClass: inetOrgPerson\nobjectClass: posixAccount\nobjectClass: shadowAccount\nobjectClass: sambaSAMAccount\nobjectClass: inetLocalMailRecipient\ncn: Fred Bloggs\nsn: fred\nuid: fred\nuidNumber: 1001\ngidNumber: 513\nsambaPwdLastSet: 1129147868\n";
        StringBufferInputStream is = new StringBufferInputStream(ldifString);
        DataInputStream stream = new DataInputStream(is);
        LDIF ldif = new LDIF(stream);
        pipe.pour(ldif);
        String xml = writer.toString();
        Test.assertEquals((String)"<?xml version=\"1.0\"?>\n<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><inseePerson xmlns=\"http://xml.insee.fr/schema/ldap/annuaire/\"><ldapDN>uid=fred,ou=Users,dc=dyomedea,dc=com</ldapDN><objectclass>top</objectclass><objectclass>inetOrgPerson</objectclass><objectclass>posixAccount</objectclass><objectclass>shadowAccount</objectclass><objectclass>sambaSAMAccount</objectclass><objectclass>inetLocalMailRecipient</objectclass><gidnumber>513</gidnumber><uidnumber>1001</uidnumber><uid>fred</uid><sambapwdlastset>1129147868</sambapwdlastset><sn>fred</sn><cn>Fred Bloggs</cn></inseePerson></rdf:RDF>", (String)xml);
    }

    public void testLdap2JavaObjectPipe1() throws Throwable {
        Ldap2JavaObjectPipe pipe = new Ldap2JavaObjectPipe();
        pipe.setParameter("topLevel", "org.treebind.tests.Foo");
        String ldif = "dn: uid=whatever,o=treebind,c=org\nbar: barValue\nbat: batValue\n";
        pipe.parseLdifString(ldif);
        Object object = pipe.getObject();
        Test.assertEquals((String)"org.treebind.tests.Foo", (String)object.getClass().getName());
        Foo foo = (Foo)pipe.getObject();
        Test.assertEquals((String)"barValue", (String)foo.getBar());
        Test.assertEquals((String)"batValue", (String)foo.getBat());
    }

    public void testLdap2JavaObjectPipe2() throws Throwable {
        Ldap2JavaObjectPipe pipe = new Ldap2JavaObjectPipe();
        pipe.setParameter("rootLevel", "java.util.Vector");
        pipe.setParameter("topLevel", "org.treebind.tests.Foo");
        String ldif = "dn: uid=whatever1,o=treebind,c=org\nbar: barValue1\nbat: batValue1\n\ndn: uid=whatever2,o=treebind,c=org\nbar: barValue2\nbat: batValue2\n";
        pipe.parseLdifString(ldif);
        Object object = pipe.getObject();
        Test.assertEquals((String)"java.util.Vector", (String)object.getClass().getName());
        Vector vector = (Vector)pipe.getObject();
        Iterator iterator = vector.iterator();
        Test.assertEquals((boolean)true, (boolean)iterator.hasNext());
        object = iterator.next();
        Test.assertEquals((String)"org.treebind.tests.Foo", (String)object.getClass().getName());
        Foo foo = (Foo)object;
        Test.assertEquals((String)"barValue1", (String)foo.getBar());
        Test.assertEquals((String)"batValue1", (String)foo.getBat());
        Test.assertEquals((boolean)true, (boolean)iterator.hasNext());
        object = iterator.next();
        Test.assertEquals((String)"org.treebind.tests.Foo", (String)object.getClass().getName());
        foo = (Foo)object;
        Test.assertEquals((String)"barValue2", (String)foo.getBar());
        Test.assertEquals((String)"batValue2", (String)foo.getBat());
        Test.assertEquals((boolean)false, (boolean)iterator.hasNext());
    }
}

