/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.xml.serialize.XMLSerializer;
import org.treebind.DefaultPipeElementImplementation;
import org.treebind.Name;
import org.treebind.Pipe;
import org.treebind.Sink;
import org.treebind.XmlAttributeName;
import org.treebind.XmlProductionName;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlSaxSink
extends DefaultPipeElementImplementation
implements Sink {
    private ContentHandler contentHandler = null;
    Hashtable inverseNsMappings = new Hashtable();
    private Stack stack = null;

    public XmlSaxSink() {
    }

    public XmlSaxSink(Pipe pipe) {
        super(pipe);
    }

    public XmlSaxSink(Pipe pipe, ContentHandler contentHandler) {
        super(pipe);
        this.setContentHandler(contentHandler);
    }

    public XmlSaxSink(Pipe pipe, Writer writer) {
        super(pipe);
        this.setContentHandler((ContentHandler)new XMLSerializer(writer, null));
    }

    public void addLeaf(Name role, Name nature, Object value) throws SAXException {
        Context previous = this.stack == null ? null : (Context)this.stack.peek();
        if (this.canBeSentAsAttribute(previous, nature)) {
            previous.addAttribute(nature, value);
        } else if (XmlProductionName.TEXTNODE.equals(nature)) {
            if (!previous.attributesHaveBeenSent()) {
                this.startElement(previous);
            }
            this.contentHandler.characters(value.toString().toCharArray(), 0, value.toString().length());
        } else {
            this.startProperty(role, nature);
            Context context = (Context)this.stack.peek();
            this.startElement(context);
            this.contentHandler.characters(value.toString().toCharArray(), 0, value.toString().length());
            this.endProperty();
        }
    }

    public boolean canBeSentAsAttribute(Context previous, Name nature) {
        XmlAttributeName xmlAttributeName;
        if (previous == null) {
            return false;
        }
        if (previous.attributesHaveBeenSent()) {
            return false;
        }
        return nature instanceof XmlAttributeName && ((xmlAttributeName = (XmlAttributeName)nature).isLocal() || this.inverseNsMappings.containsKey(nature.getDomainName()));
    }

    public void endProperty() throws SAXException {
        Context previous;
        Context context = (Context)this.stack.pop();
        if (!context.attributesHaveBeenSent()) {
            this.startElement(context);
        }
        Name nature = context.getNature();
        this.contentHandler.endElement(nature.getDomainName(), nature.getLocalName(), this.qname(nature));
        if (this.stack.empty()) {
            previous = null;
            this.contentHandler.endDocument();
        } else {
            previous = (Context)this.stack.peek();
        }
        if (this.prefixNeeded(context, previous)) {
            this.contentHandler.endPrefixMapping("");
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    private boolean prefixNeeded(Context context, Context previous) {
        if (this.inverseNsMappings.containsKey(context.getNature().getDomainName())) {
            return false;
        }
        if (previous == null) {
            return !context.getNature().getDomainName().equals("");
        }
        return !context.getNature().getDomainName().equals(previous.getDefaultNamespace());
    }

    private String qname(Name name) {
        String prefix = (String)this.inverseNsMappings.get(name.getDomainName());
        if (prefix == null) {
            return name.getLocalName();
        }
        return String.valueOf(prefix) + ":" + name.getLocalName();
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    void startElement(Context context) throws SAXException {
        this.contentHandler.startElement(context.getNature().getDomainName(), context.getNature().getLocalName(), this.qname(context.getNature()), context.getAndDeleteAttributes());
    }

    private void startPrefixMappings(Context context) throws SAXException {
        String currentNamespace = context.getNature().getDomainName();
        if (this.pipe != null) {
            boolean isDeclared = false;
            Hashtable mappings = (Hashtable)this.pipe.getParameterWithDefault("xmlns", new Hashtable());
            Enumeration enumeration = mappings.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String namespaceUri = (String)mappings.get(key);
                if ("".equals(key)) continue;
                isDeclared = isDeclared || currentNamespace.equals(namespaceUri);
                this.contentHandler.startPrefixMapping(key, namespaceUri);
                this.inverseNsMappings.put(namespaceUri, key);
            }
        }
    }

    public void startProperty(Name role, Name nature) throws SAXException {
        String defaultNs;
        Context previous;
        Context context = new Context(role, nature);
        if (this.stack == null) {
            this.stack = new Stack();
            previous = null;
            this.contentHandler.startDocument();
            this.startPrefixMappings(context);
        } else {
            previous = (Context)this.stack.peek();
            if (!previous.attributesHaveBeenSent()) {
                this.startElement(previous);
            }
        }
        this.stack.push(context);
        if (this.prefixNeeded(context, previous)) {
            this.contentHandler.startPrefixMapping("", nature.getDomainName());
            context.setDefaultNamespace(nature.getDomainName());
        } else if (previous != null) {
            context.setDefaultNamespace(previous.getDefaultNamespace());
        } else if (this.pipe != null && (defaultNs = (String)this.pipe.getParameter("xmlns", "")) != null) {
            this.contentHandler.startPrefixMapping("", defaultNs);
            context.setDefaultNamespace(defaultNs);
        }
    }

    class Context {
        AttributesImpl attributes;
        String defaultNamespace = "";
        Name nature;
        Name role;

        Context(Name role, Name nature) {
            this.role = role;
            this.nature = nature;
            this.attributes = new AttributesImpl();
        }

        public void addAttribute(Name name, Object value) {
            this.attributes.addAttribute(name.getDomainName(), name.getLocalName(), XmlSaxSink.this.qname(name), "", value.toString());
        }

        public boolean attributesHaveBeenSent() {
            return this.attributes == null;
        }

        public AttributesImpl getAndDeleteAttributes() {
            AttributesImpl attributes = this.attributes;
            this.attributes = null;
            return attributes;
        }

        public String getDefaultNamespace() {
            return this.defaultNamespace;
        }

        public Name getNature() {
            return this.nature;
        }

        public Name getRole() {
            return this.role;
        }

        public void setDefaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
        }
    }
}

