/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import java.util.Iterator;
import java.util.Stack;
import org.treebind.ComplexProperty;
import org.treebind.DefaultFilterImplementation;
import org.treebind.Filter;
import org.treebind.LeafProperty;
import org.treebind.Name;
import org.treebind.Pipe;
import org.treebind.Property;
import org.treebind.Sink;

public class TreeBom
extends DefaultFilterImplementation
implements Filter {
    Property root;
    Stack stack;

    public TreeBom() {
    }

    public TreeBom(Pipe pipe) {
        super(pipe);
    }

    public void addLeaf(Name role, Name nature, Object value) throws Exception {
        if (this.getSink() != null) {
            this.getSink().addLeaf(role, nature, value);
        }
        LeafProperty current = new LeafProperty(role, nature, value);
        if (this.stack == null) {
            this.stack = new Stack();
            this.root = current;
        } else {
            Property previous = (Property)this.stack.peek();
            previous.addProperty(current);
        }
    }

    public void endProperty() throws Exception {
        if (this.getSink() != null) {
            this.getSink().endProperty();
        }
        this.stack.pop();
    }

    public Property getRoot() {
        return this.root;
    }

    public void pour(Sink sink) throws Exception {
        this.pour(sink, this.getRoot());
    }

    public void pour(Sink sink, Property property) throws Exception {
        if (property instanceof LeafProperty) {
            sink.addLeaf(property.getRole(), property.getNature(), property.getValue());
        } else {
            sink.startProperty(property.getRole(), property.getNature());
            Iterator iterator = property.getProperties();
            while (iterator.hasNext()) {
                this.pour(sink, (Property)iterator.next());
            }
            sink.endProperty();
        }
    }

    public void startProperty(Name role, Name nature) throws Exception {
        if (this.getSink() != null) {
            this.getSink().startProperty(role, nature);
        }
        ComplexProperty current = new ComplexProperty(role, nature);
        if (this.stack == null) {
            this.stack = new Stack();
            this.root = current;
        } else {
            Property previous = (Property)this.stack.peek();
            previous.addProperty(current);
        }
        this.stack.push(current);
    }
}

