/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import java.lang.reflect.Method;
import java.util.Stack;
import org.treebind.DefaultPipeElementImplementation;
import org.treebind.JavaMethodName;
import org.treebind.Name;
import org.treebind.Pipe;
import org.treebind.Sink;

public class JavaObjectSink
extends DefaultPipeElementImplementation
implements Sink {
    private Object object;
    private Stack stack = null;

    public JavaObjectSink() {
    }

    public JavaObjectSink(Pipe pipe) {
        this.setPipe(pipe);
    }

    public String adderName(Name name) {
        return "add" + name.getLocalName();
    }

    public void addLeaf(Name role, Name nature, Object value) throws Exception {
        Context context = new Context(role, nature, value);
        if (this.stack != null) {
            Context previous = (Context)this.stack.peek();
            if (previous.object != null) {
                Method method = this.getMethod(previous.getObject(), role, value);
                if (method != null) {
                    Object[] params = new Object[]{value};
                    method.invoke(previous.getObject(), params);
                } else if (!"ignore".equals(this.pipe.getParameter("sinkNoSuchMethod"))) {
                    throw new NoSuchMethodException("No method found, class " + previous.getObject().getClass().getName() + ", role " + role.getFullName() + ", nature " + nature.getFullName());
                }
            }
        }
        if (this.stack == null) {
            this.stack = new Stack();
        }
        this.stack.push(context);
        this.endProperty();
    }

    public void endProperty() throws Exception {
        Context context = (Context)this.stack.pop();
        this.object = context.getObject();
    }

    public String genericAdderName(Name name) {
        return "add";
    }

    private Method getMatchingMethod(Method[] methods, String nameString, Class[] paramTypes, boolean strict) {
        int i = 0;
        while (i < methods.length) {
            Class<?>[] pt;
            Method m = methods[i];
            if (m.getName().equals(nameString) && (pt = m.getParameterTypes()).length == paramTypes.length) {
                int j = 0;
                while (j < pt.length) {
                    if (strict ? !pt[j].equals(paramTypes[j]) : !pt[j].isAssignableFrom(paramTypes[j])) break;
                    ++j;
                }
                if (j == paramTypes.length) {
                    return m;
                }
            }
            ++i;
        }
        return null;
    }

    private Method getMethod(Object object, Name role, Object value) {
        Method[] methods = object.getClass().getMethods();
        Object[] params = new Object[]{object};
        Class[] paramTypes = new Class[]{value.getClass()};
        JavaMethodName javaMethodName = new JavaMethodName(role);
        if (javaMethodName.isGuess()) {
            String nameString = this.adderName(role);
            Method m = this.getMatchingMethod(methods, nameString, paramTypes, true);
            if (m != null) {
                return m;
            }
            m = this.getMatchingMethod(methods, nameString, paramTypes, false);
            if (m != null) {
                return m;
            }
            nameString = this.setterName(role);
            m = this.getMatchingMethod(methods, nameString, paramTypes, true);
            if (m != null) {
                return m;
            }
            m = this.getMatchingMethod(methods, nameString, paramTypes, false);
            if (m != null) {
                return m;
            }
            nameString = this.genericAdderName(role);
            m = this.getMatchingMethod(methods, nameString, paramTypes, true);
            if (m != null) {
                return m;
            }
            m = this.getMatchingMethod(methods, nameString, paramTypes, false);
            return m;
        }
        String nameString = role.getLocalName();
        Method m = this.getMatchingMethod(methods, nameString, paramTypes, true);
        if (m != null) {
            return m;
        }
        m = this.getMatchingMethod(methods, nameString, paramTypes, false);
        return m;
    }

    public Object getObject() {
        return this.object;
    }

    public String setterName(Name name) {
        return "set" + name.getLocalName();
    }

    public void startProperty(Name role, Name nature) throws Exception {
        Object object;
        String className = nature.getFullName();
        try {
            Class<?> klass = Class.forName(className);
            object = klass.newInstance();
        }
        catch (ClassNotFoundException e) {
            if ("ignore".equals(this.pipe.getParameter("sinkClassNotFound"))) {
                object = null;
            }
            throw e;
        }
        Context context = new Context(role, nature, object);
        if (this.stack != null) {
            if (object != null) {
                Context previous = (Context)this.stack.peek();
                Method method = this.getMethod(previous.getObject(), role, object);
                if (method != null) {
                    Object[] params = new Object[]{object};
                    method.invoke(previous.getObject(), params);
                } else if (!"ignore".equals(this.pipe.getParameter("sinkNoSuchMethod"))) {
                    throw new NoSuchMethodException("No method found, class " + previous.getObject().getClass().getName() + ", role " + role.getFullName() + ", nature " + nature.getFullName());
                }
            }
        } else {
            this.stack = new Stack();
        }
        this.stack.push(context);
    }

    class Context {
        Name nature;
        Object object = null;
        Name role;

        Context(Name role, Name nature, Object object) {
            this.object = object;
            this.role = role;
            this.nature = nature;
        }

        public Name getNature() {
            return this.nature;
        }

        public Object getObject() {
            return this.object;
        }

        public Name getRole() {
            return this.role;
        }
    }
}

