/*
 * Decompiled with CFR 0.152.
 */
package org.treebind;

import java.util.Hashtable;
import org.treebind.Filter;
import org.treebind.OutOfSyncException;
import org.treebind.Pipe;
import org.treebind.Sink;
import org.treebind.Source;

public class DefaultPipeImplementation
implements Pipe {
    private Filter currentFilter = null;
    private Hashtable parameters = new Hashtable();
    private Sink sink = null;
    private Source source = null;

    public void addFilter(Filter filter) throws OutOfSyncException {
        if (this.currentFilter != null) {
            filter.setSink(this.currentFilter);
            this.currentFilter = filter;
        } else if (this.sink != null) {
            filter.setSink(this.sink);
            this.currentFilter = filter;
        } else {
            throw new OutOfSyncException("Should set a Sink before adding a Filter.");
        }
    }

    public void addFilterAfterSource(Filter newFilter) {
        Source source = this.getSource();
        Filter filter = (Filter)source.getSink();
        source.setSink(newFilter);
        newFilter.setSink(filter);
    }

    public void addFilterBeforeSink(Filter newFilter) {
        Filter filter = (Filter)this.getSource().getSink();
        Sink sink = filter.getSink();
        filter.setSink(newFilter);
        newFilter.setSink(sink);
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public Object getParameter(String name, String key) {
        Hashtable h = (Hashtable)this.getParameter(name);
        if (h == null) {
            return null;
        }
        return h.get(key);
    }

    public Object getParameterWithDefault(String name, Object defaultValue) {
        Object value = this.parameters.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Object getParameterWithDefault(String name, String key, Object defaultValue) {
        Object value = this.getParameter(name, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Sink getSink() {
        return this.sink;
    }

    public Source getSource() {
        return this.source;
    }

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public void setParameter(String name, String key, Object value) {
        Hashtable h = this.getParameter(name) == null ? new Hashtable() : (Hashtable)this.getParameter(name);
        h.put(key, value);
        this.setParameter(name, h);
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public void setSource(Source source) throws OutOfSyncException {
        if (this.currentFilter != null) {
            source.setSink(this.currentFilter);
        } else if (this.sink != null) {
            source.setSink(this.sink);
        } else {
            throw new OutOfSyncException("Should set at least a Sink before setting the source.");
        }
        this.source = source;
    }
}

