/**
 * This file has no copyright assigned and is placed in the Public Domain.
 * This file is part of the w64 mingw-runtime package.
 * No warranty is given; refer to the file DISCLAIMER within this package.
 */
#ifndef _PDH_MSG_H_
#define _PDH_MSG_H_

#define STATUS_SEVERITY_WARNING 0x2
#define STATUS_SEVERITY_SUCCESS 0x0
#define STATUS_SEVERITY_INFORMATIONAL 0x1
#define STATUS_SEVERITY_ERROR 0x3

#define PDH_CSTATUS_VALID_DATA ((DWORD)0x00000000L)
#define PDH_CSTATUS_NEW_DATA ((DWORD)0x00000001L)
#define PDH_CSTATUS_NO_MACHINE ((DWORD)0x800007D0L)
#define PDH_CSTATUS_NO_INSTANCE ((DWORD)0x800007D1L)
#define PDH_MORE_DATA ((DWORD)0x800007D2L)
#define PDH_CSTATUS_ITEM_NOT_VALIDATED ((DWORD)0x800007D3L)
#define PDH_RETRY ((DWORD)0x800007D4L)
#define PDH_NO_DATA ((DWORD)0x800007D5L)
#define PDH_CALC_NEGATIVE_DENOMINATOR ((DWORD)0x800007D6L)
#define PDH_CALC_NEGATIVE_TIMEBASE ((DWORD)0x800007D7L)
#define PDH_CALC_NEGATIVE_VALUE ((DWORD)0x800007D8L)
#define PDH_DIALOG_CANCELLED ((DWORD)0x800007D9L)
#define PDH_END_OF_LOG_FILE ((DWORD)0x800007DAL)
#define PDH_ASYNC_QUERY_TIMEOUT ((DWORD)0x800007DBL)
#define PDH_CANNOT_SET_DEFAULT_REALTIME_DATASOURCE ((DWORD)0x800007DCL)
#define PDH_CSTATUS_NO_OBJECT ((DWORD)0xC0000BB8L)
#define PDH_CSTATUS_NO_COUNTER ((DWORD)0xC0000BB9L)
#define PDH_CSTATUS_INVALID_DATA ((DWORD)0xC0000BBAL)
#define PDH_MEMORY_ALLOCATION_FAILURE ((DWORD)0xC0000BBBL)
#define PDH_INVALID_HANDLE ((DWORD)0xC0000BBCL)
#define PDH_INVALID_ARGUMENT ((DWORD)0xC0000BBDL)
#define PDH_FUNCTION_NOT_FOUND ((DWORD)0xC0000BBEL)
#define PDH_CSTATUS_NO_COUNTERNAME ((DWORD)0xC0000BBFL)
#define PDH_CSTATUS_BAD_COUNTERNAME ((DWORD)0xC0000BC0L)
#define PDH_INVALID_BUFFER ((DWORD)0xC0000BC1L)
#define PDH_INSUFFICIENT_BUFFER ((DWORD)0xC0000BC2L)
#define PDH_CANNOT_CONNECT_MACHINE ((DWORD)0xC0000BC3L)
#define PDH_INVALID_PATH ((DWORD)0xC0000BC4L)
#define PDH_INVALID_INSTANCE ((DWORD)0xC0000BC5L)
#define PDH_INVALID_DATA ((DWORD)0xC0000BC6L)
#define PDH_NO_DIALOG_DATA ((DWORD)0xC0000BC7L)
#define PDH_CANNOT_READ_NAME_STRINGS ((DWORD)0xC0000BC8L)
#define PDH_LOG_FILE_CREATE_ERROR ((DWORD)0xC0000BC9L)
#define PDH_LOG_FILE_OPEN_ERROR ((DWORD)0xC0000BCAL)
#define PDH_LOG_TYPE_NOT_FOUND ((DWORD)0xC0000BCBL)
#define PDH_NO_MORE_DATA ((DWORD)0xC0000BCCL)
#define PDH_ENTRY_NOT_IN_LOG_FILE ((DWORD)0xC0000BCDL)
#define PDH_DATA_SOURCE_IS_LOG_FILE ((DWORD)0xC0000BCEL)
#define PDH_DATA_SOURCE_IS_REAL_TIME ((DWORD)0xC0000BCFL)
#define PDH_UNABLE_READ_LOG_HEADER ((DWORD)0xC0000BD0L)
#define PDH_FILE_NOT_FOUND ((DWORD)0xC0000BD1L)
#define PDH_FILE_ALREADY_EXISTS ((DWORD)0xC0000BD2L)
#define PDH_NOT_IMPLEMENTED ((DWORD)0xC0000BD3L)
#define PDH_STRING_NOT_FOUND ((DWORD)0xC0000BD4L)
#define PDH_UNABLE_MAP_NAME_FILES ((DWORD)0x80000BD5L)
#define PDH_UNKNOWN_LOG_FORMAT ((DWORD)0xC0000BD6L)
#define PDH_UNKNOWN_LOGSVC_COMMAND ((DWORD)0xC0000BD7L)
#define PDH_LOGSVC_QUERY_NOT_FOUND ((DWORD)0xC0000BD8L)
#define PDH_LOGSVC_NOT_OPENED ((DWORD)0xC0000BD9L)
#define PDH_WBEM_ERROR ((DWORD)0xC0000BDAL)
#define PDH_ACCESS_DENIED ((DWORD)0xC0000BDBL)
#define PDH_LOG_FILE_TOO_SMALL ((DWORD)0xC0000BDCL)
#define PDH_INVALID_DATASOURCE ((DWORD)0xC0000BDDL)
#define PDH_INVALID_SQLDB ((DWORD)0xC0000BDEL)
#define PDH_NO_COUNTERS ((DWORD)0xC0000BDFL)
#define PDH_SQL_ALLOC_FAILED ((DWORD)0xC0000BE0L)
#define PDH_SQL_ALLOCCON_FAILED ((DWORD)0xC0000BE1L)
#define PDH_SQL_EXEC_DIRECT_FAILED ((DWORD)0xC0000BE2L)
#define PDH_SQL_FETCH_FAILED ((DWORD)0xC0000BE3L)
#define PDH_SQL_ROWCOUNT_FAILED ((DWORD)0xC0000BE4L)
#define PDH_SQL_MORE_RESULTS_FAILED ((DWORD)0xC0000BE5L)
#define PDH_SQL_CONNECT_FAILED ((DWORD)0xC0000BE6L)
#define PDH_SQL_BIND_FAILED ((DWORD)0xC0000BE7L)
#define PDH_CANNOT_CONNECT_WMI_SERVER ((DWORD)0xC0000BE8L)
#define PDH_PLA_COLLECTION_ALREADY_RUNNING ((DWORD)0xC0000BE9L)
#define PDH_PLA_ERROR_SCHEDULE_OVERLAP ((DWORD)0xC0000BEAL)
#define PDH_PLA_COLLECTION_NOT_FOUND ((DWORD)0xC0000BEBL)
#define PDH_PLA_ERROR_SCHEDULE_ELAPSED ((DWORD)0xC0000BECL)
#define PDH_PLA_ERROR_NOSTART ((DWORD)0xC0000BEDL)
#define PDH_PLA_ERROR_ALREADY_EXISTS ((DWORD)0xC0000BEEL)
#define PDH_PLA_ERROR_TYPE_MISMATCH ((DWORD)0xC0000BEFL)
#define PDH_PLA_ERROR_FILEPATH ((DWORD)0xC0000BF0L)
#define PDH_PLA_SERVICE_ERROR ((DWORD)0xC0000BF1L)
#define PDH_PLA_VALIDATION_ERROR ((DWORD)0xC0000BF2L)
#define PDH_PLA_VALIDATION_WARNING ((DWORD)0x80000BF3L)
#define PDH_PLA_ERROR_NAME_TOO_LONG ((DWORD)0xC0000BF4L)
#define PDH_INVALID_SQL_LOG_FORMAT ((DWORD)0xC0000BF5L)
#define PDH_COUNTER_ALREADY_IN_QUERY ((DWORD)0xC0000BF6L)
#define PDH_BINARY_LOG_CORRUPT ((DWORD)0xC0000BF7L)
#define PDH_LOG_SAMPLE_TOO_SMALL ((DWORD)0xC0000BF8L)
#define PDH_OS_LATER_VERSION ((DWORD)0xC0000BF9L)
#define PDH_OS_EARLIER_VERSION ((DWORD)0xC0000BFAL)
#define PDH_INCORRECT_APPEND_TIME ((DWORD)0xC0000BFBL)
#define PDH_UNMATCHED_APPEND_COUNTER ((DWORD)0xC0000BFCL)
#define PDH_SQL_ALTER_DETAIL_FAILED ((DWORD)0xC0000BFDL)
#define PDH_QUERY_PERF_DATA_TIMEOUT ((DWORD)0xC0000BFEL)

#endif
