import java.awt.*;
import java.awt.image.*;
import java.util.*;



// JavaJRotText implements  strings that will
// generate images scaled to size, and rotated in one of four
// compass directions

class JavaJRotText {

  public static final int R_0 = 0;
  public static final int R_90 = 90;
  public static final int R_180 = 180;
  public static final int R_270 = 270;

  String s_;
  Font f_;		// if we use a fixed font
  int rot_;

  int width_, height_;
  int max_len;		// length (chars) of longest string

  JavaJRotText(String s, int rot, Font f) {
    s_ = s;
    rot_ = rot;
    f_ = f;
  }

  public int getWidth() {
    return width_;
  }


  // get an image based on the supplied graphics context
  public Image getImage(Component c, Graphics g, FontMetrics fm) {

    // generate an image from the given vector of strings

    // assume we have a font
    int desc = fm.getMaxDescent();
    int ht = fm.getHeight();

    width_ = fm.stringWidth(s_);
    height_ = ht;
    f_ = fm.getFont();

    // shouldn't ever be 0...
    if (width_ == 0 || height_ == 0) return null;

    Image i = c.createImage(width_, height_);
    if (i == null) return null;

    Graphics ig = i.getGraphics();
    ig.setFont(f_);

    int base = ht - fm.getMaxDescent();	// get baseline;
    ig.drawString(s_, 0, base);

    // rotate the image, as necessary
    if (rot_ != R_0) {
      Image ni = imageRotate(i, c, width_, height_, rot_);
      i.flush();
      i = ni;
    }

    return i;
  }

  public Image getImage(Component c, Graphics g, int width, int height) {
    FontMetrics fm = g.getFontMetrics(f_);
    return getImage(c, g, fm);
  }

  private Image imageRotate(Image i, Component c,
			    int width, int height, int rot) {

    int src_array[] = new int[width*height];
    PixelGrabber src = new PixelGrabber(i, 0, 0, width, height, 
					src_array,
					0, width);
    try {
      src.grabPixels();
    } catch (InterruptedException e) {
      return i;
    }

    int dst_array[] = new int[height*width];

    for (int x=0; x < width; x++) {
      for (int y=0; y < height; y++) {
	if (rot == R_90) {
	  dst_array[(height*(width-1-x))+y] =
	    src_array[(y*width)+x];
	} else if (rot == R_270) {
	  dst_array[(x*height)+((height-1)-y)] =
	    src_array[(y*width)+x];
	} else /* rot == R_180 */ {
	  dst_array[(y*width)+x] =
	    src_array[(((height-1)-y)*width)+x];
	}
      }
    }

    MemoryImageSource ms = new MemoryImageSource(height, width, 
						 dst_array, 0, height);
    return c.getToolkit().createImage(ms);
  }

}



