//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            UniformInteger.h
Description:     Uniform distribution returning integer values
Library:         random
Original Author: Nelson Minar
Modified by:     Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/


#import <random/RandomDefs.h>
#import <random/ProbabilityDistribution.h>

@interface UniformInteger: ProbabilityDistribution //<UniformInteger>

{

// Parameters:

   int iMin;
   int iMax;
   unsigned uRange;
   unsigned uCutoff;

// Working variables:


}

// Methods that conform to the UniformInteger protocol:

+create: aZone setGenerator: generator
	setIntegerMin: (int) minValue setMax: (int) maxValue;

-setIntegerMin: (int) minValue setMax: (int) maxValue;

-(int) getIntegerMin;
-(int) getIntegerMax;

-(int) getIntegerWithMin: (int) minValue withMax: (int) maxValue;

// Methods that conform to the IntegerDistribution protocol:

-(int) getIntegerSample;

// Methods that override superclass methods:

// -(void) getState: (void *) state;
// -(void) setState: (void *) state;

// -initState;
// -resetState;

// temporary methods:

-(int) getAlternateIntegerSample;

@end
