//  Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; 
// without even the implied warranty of merchantability 
// or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

/*
Name:            SWB3gen.h
Description:     Subtract-with-Borrow generator
Library:         random
Original Author: Nelson Minar
Date:            1996-09-09
Modified by:     Sven Thommesen
Date:            1997-01-15
*/

/*
123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789|
*/

// This generator returns successive pseudo-random UNSIGNED INTEGERS
// in the closed interval [0, 2^32-1]:

// This version should have 192 distinct cycles, period roughly 10^200:

#define SWB3LONGLAG  21
#define SWB3SHORTLAG  6


#import <random/RandomNumberGenerator.h>


@interface SWB3: RandomNumberGenerator

{

// Parameters:

   unsigned s;		// short lag
   unsigned r;		// long lag (=size of state vector)

// Data objects (state variables):

   int carry;			// carry bit
   unsigned index;		// pointer to current value
   unsigned state[SWB3LONGLAG];	// vector of lagged values (state vector)

}

// The following RandomNumberGenerator methods are overridden:

// -initState;
// -resetState;

// -(void) getState: (void *) stateBuf;
// -(void) setState: (void *) stateBuf;

// -(unsigned) getUnsignedSample;

@end
