#import "BankObserverSwarm.h"
#import "BankModelSwarm.h"
#import <collections.h>
#import <swarmobject.h>

@implementation BankObserverSwarm

// createBegin: here we set up the default observation parameters.
+createBegin: (id) aZone {
  BankObserverSwarm * obj;
  ProbeMap * probeMap;
  
  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;
  obj->interactiveGraph = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "interactiveGraph"
				    inClass: [self class]]];

  [probeMap addProbe: [[probeLibrary getProbeForMessage: "redistribute"
			     inClass: [self class]]
			setHideResult: 1]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

-createEnd {
  return [super createEnd];
}

-buildObjects {
  id modelZone;	

  [super buildObjects];
  
  modelZone = [Zone create: [self getZone]];
  bankModelSwarm = [BankModelSwarm create: modelZone];
  
  // Now create probe objects on the model and ourselves. This gives a
  // simple user interface to let the user change parameters.
  [probeDisplayManager createProbeDisplayFor: bankModelSwarm];
  [probeDisplayManager createProbeDisplayFor: self];


  [controlPanel waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
    return self;

  if(interactiveGraph){
    graphCanvas = [Canvas create: [self getZone]] ;
    [graphCanvas setWidth: 500 Height: 500] ;
    [graphCanvas setWindowTitle: "The Emergence Of Banking"] ;
#ifdef _TK_
    [globalTkInterp eval: 
      "pack %s -expand 1 -fill both ; update idletasks", 
      [graphCanvas getWidgetName]] ;
#endif
  }
 
  [bankModelSwarm setGraphCanvas: graphCanvas] ;
  [bankModelSwarm buildObjects];

  activeBanks = [EZGraph createBegin: [self getZone]] ;
  [activeBanks setTitle: "Active Banks"] ;
  [activeBanks setAxisLabelsX: "Time" Y: "Banks"] ;
  activeBanks = [activeBanks createEnd] ;

  [activeBanks createTotalSequence: "Survivors" 
                      withFeedFrom: [bankModelSwarm getEntityList]
                       andSelector: M(incident)] ;

  investorGraph = [BLTGraph create: [self getZone]];
  [investorGraph title: "Entropy of investor link distribution"];
  [investorGraph axisLabelsX: "time" Y: "prop. of Max. Entropy"];
  [investorGraph pack];

  investorData = [investorGraph createElement];
  [investorData setLabel: "H(investors)"];

  investorEntropy = [Entropy createBegin: [self getZone]];
  [investorEntropy setCollection: [bankModelSwarm getEntityList]];
  [investorEntropy setProbedSelector: M(getInvestorLinkProbability)];
  investorEntropy = [investorEntropy createEnd];

  investorGrapher = [ActiveGraph createBegin: [self getZone]];
  [investorGrapher setElement: investorData];
  [investorGrapher setDataFeed: investorEntropy]; // chain them up
  [investorGrapher setProbedSelector: M(getEntropy)];
  investorGrapher = [investorGrapher createEnd];

  borrowerData = [investorGraph createElement];
  [borrowerData setLabel: "H(borrowers)"];

  borrowerEntropy = [Entropy createBegin: [self getZone]];
  [borrowerEntropy setCollection: [bankModelSwarm getEntityList]];
  [borrowerEntropy setProbedSelector: M(getBorrowLinkProbability)];
  borrowerEntropy = [borrowerEntropy createEnd];

  borrowerGrapher = [ActiveGraph createBegin: [self getZone]];
  [borrowerGrapher setElement: borrowerData];
  [borrowerGrapher setDataFeed: borrowerEntropy]; // chain them up
  [borrowerGrapher setProbedSelector: M(getEntropy)];
  borrowerGrapher = [borrowerGrapher createEnd];

  return self;
}  

-redistribute {
  [[bankModelSwarm getTheFNet] redistribute] ;
  return self ;
}

-buildActions {
  [super buildActions];
  
  [bankModelSwarm buildActions];
  
  displayActions = [ActionGroup create: [self getZone]];
/*
  // Schedule up the methods to draw the display of the world
  [displayActions createActionTo: heatDisplay         message: M(display)];
  [displayActions createActionTo: heatbugDisplay      message: M(display)];
  [displayActions createActionTo: worldRaster         message: M(drawSelf)];
  // Now schedule the update of the unhappiness graph
  // Schedule the update of the probe displays
*/
  [displayActions createActionTo: activeBanks  message: M(step)];
  [displayActions createActionTo: investorEntropy message: M(update)];
  [displayActions createActionTo: investorGrapher  message: M(step)];
  [displayActions createActionTo: borrowerEntropy message: M(update)];
  [displayActions createActionTo: borrowerGrapher  message: M(step)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
#ifdef _TK_
  [displayActions createActionTo: controlPanel        message: M(doTkEvents)];
#else
  [displayActions createActionTo: controlPanel        message: M(checkState)];
#endif

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

-activateIn: (id) swarmContext {

  [super activateIn: swarmContext];

  [bankModelSwarm activateIn: self];

  [displaySchedule activateIn: self];

  return [self getSwarmActivity];
}

// You could override the "go" method here if you want something special
// to happen when the model and observer actually start running. But
// the default GUISwarm go is probably good enough.

@end
