
#ifndef _JAVA_CLASS_H
#define _JAVA_CLASS_H

/*
 *  JavaClass:  encapsulate a java class; allow users to query method
 *  ids and call static methods on the class
 */

#include "jni.h"
#include <objc/Object.h>

@interface JavaClass : Object {
  JNIEnv * env;
  jclass clsid;
}

+ new:  (char *)class env: (id)_env;

- init: (char *)class env: (id) _env;

- (JNIEnv *)getEnv;
- (jmethodID)findMethod: (char *)method signature: (char *) sig;
- (jmethodID)findStaticMethod: (char *)method signature: (char *) sig;
- (jobject) callObjectStaticMethod: (jmethodID) mid;

@end

#endif
