/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.constants.Node;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import fr.gouv.culture.sdx.utils.save.Saveable;

public class MYSQLDatabase extends JDBCDatabase {

	protected final String FIELD_KEY = "sdx_key";

	protected String getTableCreationQuery() {
		return "CREATE TABLE " + getTableName() + " ( " + FIELD_ID + " VARCHAR(255) NOT NULL, " + FIELD_PROPERTY_NAME + " VARCHAR(255) NOT NULL, " + FIELD_PROPERTY_VALUE + " VARCHAR(255) NOT NULL, " + FIELD_KEY + " INT AUTO_INCREMENT, "
				+ "PRIMARY KEY (" + FIELD_KEY + "))";
	}

	/* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.AbstractSdxObject#initToSax()
	 */
	protected boolean initToSax() {
		this._xmlizable_objects.put("Database_Type","MYSQLDatabase");
		this._xmlizable_objects.put("JDBC_Table_Name",this.tableName);
		this._xmlizable_objects.put("Data_Source_Identifier",this.dsi);
		return true;
	}

	/** Save the database
	 * @see fr.gouv.culture.sdx.utils.save.Saveable#backup(fr.gouv.culture.sdx.utils.save.SaveParameters)
	 */
	public void backup(SaveParameters save_config) throws SDXException {
		super.backup(save_config);
		if(save_config != null)
			if(save_config.getAttributeAsBoolean(Saveable.ALL_SAVE_ATTRIB,false))
			{
				save_config.setAttribute(Node.Name.TYPE,"MYSQL");
			}
	}

	/**
	 * @see fr.gouv.culture.sdx.utils.database.AbstractJDBCDatabase#getAllEntitiesWithLimitQuery(long, long)
	 * MYSQL implementation
	 * SELECT * FROM &gt;table_name&lt; LIMIT &gt;offset&lt;,&gt;number&lt; ;
	 */
	protected String getEntriesWithLimitQuery(long offset, long number) {
		String query = "SELECT * FROM " + getTableName();
		query += " LIMIT " + String.valueOf(offset) + "," + String.valueOf(number) + ";";
		return query;
	}

	/** Restore the database
	 * @see fr.gouv.culture.sdx.utils.save.Saveable#restore(fr.gouv.culture.sdx.utils.save.SaveParameters)
	 */
	public void restore(SaveParameters save_config) throws SDXException {
		super.restore(save_config);
	}
}
