/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.constants.Node;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import fr.gouv.culture.sdx.utils.save.Saveable;

/**
 * Created by Mobydoc.
 * User: Vincent Leconte
 * Date: 12/03/2008
 * Time: 17:30:24
 * To change this template use Options | File Templates.
 */
public class MSSQLDatabase extends JDBCDatabase {

	protected final String FIELD_ID = "id";
	protected final String FIELD_PROPERTY_NAME = "propertyName";
	protected final String FIELD_PROPERTY_VALUE = "propertyValue";
	protected final String FIELD_KEY = "sdx_key";

	protected String getTableCreationQuery() {
		return "CREATE TABLE " + getTableName() + " ( " + FIELD_ID + " VARCHAR(255) NOT NULL, " + FIELD_PROPERTY_NAME + " VARCHAR(255) NOT NULL, " + FIELD_PROPERTY_VALUE + " VARCHAR(255) NOT NULL, " + FIELD_KEY + " INT IDENTITY(1,1), "
		+ "PRIMARY KEY (" + FIELD_KEY + "))";
	}

	/* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.AbstractSdxObject#initToSax()
	 */
	protected boolean initToSax() {
		this._xmlizable_objects.put("Database_Type","MSSQLDatabase");
		this._xmlizable_objects.put("JDBC_Table_Name",this.tableName);
		this._xmlizable_objects.put("Data_Source_Identifier",this.dsi);
		return true;
	}

	/** Save the database
	 * @see fr.gouv.culture.sdx.utils.save.Saveable#backup(fr.gouv.culture.sdx.utils.save.SaveParameters)
	 */
	public void backup(SaveParameters save_config) throws SDXException {
		super.backup(save_config);
		if(save_config != null)
			if(save_config.getAttributeAsBoolean(Saveable.ALL_SAVE_ATTRIB,false))
			{
				save_config.setAttribute(Node.Name.TYPE,"MSSQL");
			}
	}

	/**
	 * @see fr.gouv.culture.sdx.utils.database.AbstractJDBCDatabase#getAllEntitiesWithLimitQuery(long, long)
	 * MSSQL implementation (un peu lourd mais LIMIT existe pas en MSSQL)
	 * SELECT * FROM
	 *              (SELECT TOP &gt;number&lt; id, propertyName, propertyValue, sdx_key FROM
	 *                      (SELECT TOP &gt;number + offset&lt; id, propertyName, propertyValue, sdx_key FROM &gt;table_name&lt; ORDER BY sdx_key asc)
	 *      AS tbl1 ORDER BY sdx_key desc)
	 * AS tbl2 ORDR BY sdx_key asc;
	 */
	protected String getEntriesWithLimitQuery(long offset, long number) {
		String query = "SELECT * FROM ( SELECT TOP " + String.valueOf(number) + " " + FIELD_ID + ", " + FIELD_PROPERTY_NAME + ", " + FIELD_PROPERTY_VALUE + ", " + FIELD_KEY;
		query += "FROM (SELECT TOP " + String.valueOf(offset + number) + " " + FIELD_ID + ", " + FIELD_PROPERTY_NAME + ", " + FIELD_PROPERTY_VALUE + ", " + FIELD_KEY;
		query += "FROM " + getTableName() + " ORDER BY " + FIELD_KEY + " asc) AS tbl1 ORDER BY " + FIELD_KEY + " desc) AS tbl2 ORDER BY " + FIELD_KEY + " asc;";
		return query;
	}

	/** Restore the database
	 * @see fr.gouv.culture.sdx.utils.save.Saveable#restore(fr.gouv.culture.sdx.utils.save.SaveParameters)
	 */
	public void restore(SaveParameters save_config) throws SDXException {
		super.restore(save_config);
	}
}