/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;

import java.sql.Connection;
import java.sql.SQLException;

public class JDBCDatabaseConnection extends SQLDatabaseConnection {

	/** The data source. */
	private DataSourceComponent _dataSource;

	/**DataSourceComponent fucntionality not desired and should be handled by caller*/
	public JDBCDatabaseConnection(Connection conn) {
		super(conn);
	}

	/**Establishes the data source component, a simple wrapper
	 *
	 * @param dataSource
	 * @throws SQLException
	 */
	public JDBCDatabaseConnection(DataSourceComponent dataSource) throws SQLException {
		this._dataSource = dataSource;
		if (this._dataSource != null)
			super.conn = this._dataSource.getConnection();
	}

	/**
	 *Returns the datasource component from which this connection was derived
	 */
	public DataSourceComponent getDataSource() {
		return this._dataSource;
	}

	/**Releases the SQL Connection to the datasource
	 *
	 * @throws SDXException
	 */
	protected void releaseSqlConnection() throws SDXException {
		super.close();
	}
}
