/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.thesaurus;

import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.utils.constants.Node;

public interface Concept extends IndexableDocument {

    /**Identifier of the subclass document type*/
    String DOCTYPE_CONCEPT = "concept";

    String TERM = Node.Name.TERM;
    String ABBREVIATION_SCOPE_NOTE = "sn";
    String RELATION_NARROWER_TERM = "nt";
    String RELATION_BROADER_TERM = "bt";
    String RELATION_BROADER_TERMS = "bts";
    String RELATION_USED_FOR = "uf";
    String RELATION_EQUIVALENT_TERM = "et";
    String RELATION_RELATED_TERM = "rt";
    String RELATION_USE = "use";
    String RELATION_PARTIAL_EQIUVALENCE = "pe";

    String XMLLANG = "xmllang";

    /**Sets the term/value of the document
     *
     * @param value     The value
     */
    void setValue(String value);

    /**
     * Returns the document value (name, description, ...).
     */
    String getValue();

    /**Adds a relation to the document
     *
     * @param relationType   The relation type name or other key
     * @param relationValue The relation value or term
     */
    void addRelation(String relationType, String relationValue);

    /**
     * Returns a list of concept ids related to this one.
     *
     * @param   type The relation type.
     * @deprecated use getRelations(String type)
     */
    public String[] getRelations(int type);

    /**
     * Returns a list of concept ids related to this one.
     *
     * @param   type The relation type String.
     */
    public String[] getRelations(String type);

}
