/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.search.lucene.analysis;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.lucene.analysis.TokenStream;
import org.apache.excalibur.xml.sax.XMLizable;

import java.io.Reader;

/**
 * An analyzers is used in indexing and querying for extracting words.
 */
public interface Analyzer extends LogEnabled, Configurable, java.io.Serializable, XMLizable {

    /** Creates a TokenStream which tokenizes all the text in the provided
     Reader.  Default implementation forwards to tokenStream(Reader) for
     compatibility with older version.  Override to allow Analyzer to choose
     strategy based on document and/or field.  Must be able to handle null
     field name for backward compatibility. */
    TokenStream tokenStream(String fieldName, Reader reader);

    /** Creates a TokenStream which tokenizes all the text in the provided
     *  Reader.  Provided for backward compatibility only.
     * @deprecated use tokenStream(String, Reader) instead.
     * @see #tokenStream(String, java.io.Reader)
     */
    TokenStream tokenStream(Reader reader);
}
