/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
/*
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 17 oct. 2002
 * Time: 16:06:46
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.Utilities;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;

import java.io.IOException;

public class LuceneRepositoryConnection extends AbstractRepositoryConnection {

    /**The Directory for the index which should be optimized*/
    private String indexPath = null;

    /**The analyzer for the index*/
    private final StandardAnalyzer analyzer = new StandardAnalyzer();

    /**Adding the necessary parameters for optimization*/
    public void setUp(String indexPath) {
        this.indexPath = indexPath;
    }

    /**Can do optimization of a Repository if needed*/
    public void optimize() throws SDXException {

        if (Utilities.checkString(this.indexPath) && this.analyzer != null) {
            //passing false so as to not overwrite contents
            IndexWriter w = null;
            try {
                w = new IndexWriter(this.indexPath, this.analyzer, false);
                w.optimize();
            } catch (IOException e) {
                String[] args = new String[1];
                args[0] = this.indexPath;
                throw new SDXException(super.getLog(), SDXExceptionCode.ERROR_LUCENE_OPTIMIZE, args, e);

            } finally {
                if (w != null)
                    try {
                        w.close();
                    } catch (IOException e) {
                        String[] args = new String[1];
                        args[0] = this.indexPath;
                        throw new SDXException(super.getLog(), SDXExceptionCode.ERROR_LUCENE_OPTIMIZE, args, e);
                    }
            }
        }
    }


}
