/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.oai;

import org.apache.cocoon.xml.AbstractXMLPipe;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import fr.gouv.culture.oai.OAIObject;

/**OAI elements characterizing a harvest must be removed to recover the original document.
 * @author Malo Pichot
 */
public class OAIEnvelopStripper extends AbstractXMLPipe {

    private boolean deleteChars = true;
    private boolean isMetadataDescendant = false;

    public OAIEnvelopStripper() {
        //Nothing here
    }

    /**Activate the copy of the content if needed*/
    public void characters(char chars[], int start, int length) 
	throws SAXException 
	{
        if ( !deleteChars ) {//if deleteChars is false, copy characters content
        	super.characters(chars, start, length);
        }
    }

    /**Activate the copy of the end element if needed*/
    public void endElement(String namespace, String name, String qualifiedName) 
    throws SAXException 
    {
    	if ( name.equals( OAIObject.Node.Name.METADATA ) 
    			&& namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) )
    	{
        	isMetadataDescendant = false;
        }
        if ( !namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) 
        		|| isMetadataDescendant )
        {
        	// FIXME (MP) : Faut-il etre plus intelligent que les concepteurs de l'entrepot OAI et supprimer le namespace s'il est celui du protocole OAI ?
        	// if ( namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) ) {
        	// 	namespace = "";
        	// 	qualifiedName = name;
        	// }
            super.endElement(namespace, name, qualifiedName);
            deleteChars = true;
        }
    }

    /**Activate the copy of the start element if needed*/
    public void startElement(String namespace, String name, String qualifiedName, Attributes attributes) 
    throws SAXException 
    {
        if ( !namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) 
        		|| isMetadataDescendant )
        {
            deleteChars = false;
        	// FIXME (MP) : Faut-il etre plus intelligent que les concepteurs de l'entrepot OAI et supprimer le namespace s'il est celui du protocole OAI ?
        	// if ( namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) ) {
        	// 	namespace = "";
        	// 	qualifiedName = name;
        	// }
            super.startElement(namespace, name, qualifiedName, attributes);
        }
    	if ( name.equals( OAIObject.Node.Name.METADATA ) 
    			&& namespace.equals(OAIObject.Node.Xmlns.OAI_2_0) )
    	{
        	isMetadataDescendant = true;
        }
    }

}