/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.document;

import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.utils.SdxObject;

import java.io.File;
import java.io.InputStream;
import java.net.URL;

/**
 * A document that can be managed by SDX.
 *
 * <p>
 * SDX is mainly a search engine for XML documents, but these documents can
 * be linked with other documents or they may not be in XML at first. That's why
 * we abstracted the concept of documents with this interface.
 */
public interface Document extends SdxObject {

    public static final String CLASS_NAME_SUFFIX = "Document";
    /** doctype HTMLDocument */
    public final static String DOCTYPE_HTML = "html";

    /** doctype XMLDocument */
    public final static String DOCTYPE_XML = "xml";

    /** doctype User */
    public final static String DOCTYPE_USER = "user";

    /** doctype Group */
    public final static String DOCTYPE_GROUP = "group";

    /** doctype Binary */
    public final static String DOCTYPE_BINARY = "binary";


    /** Sets the document's id. */
    public void setId(String id) throws SDXException;

    /** Opens a stream for reading the document's content. */
    public InputStream openStream() throws SDXException;

    /** Sets the content from a memory representation of the raw data. */
    public void setContent(byte[] b);

    /** Sets the content from a file. */
    public void setContent(File f);

    /** Sets the content from a URL. */
    public void setContent(URL r);

    /** Sets the content from an InputStream. */
    public void setContent(InputStream is);

    /** Saves the document within a repository. */
    public void save(Repository r) throws SDXException;

    /** Returns the length of the document (-1 if length can't be known). */
    public int getLength();

    /** Returns a preferred filename for this document. */
    public String getPreferredFilename();

    /** Returns a URL for this document, null if no URL can be given. */
    public URL getURL() throws SDXException;

    /** Sets the URL of this document. */
    public void setURL(URL url);

    /**Returns the mimeType field (A String) for this document*/
    public String getMimeType();

    /**Sets the mime type for the document*/
    public void setMimeType(String mimeType);

    /**Gets the docType for the document*/
    public String getDocType();

    /** Sets the preferred filename for this document. */
    public void setPreferredFilename(String filename);

    public void setIdGenerator(IDGenerator idGen, String idPrefix, String idSuffix);

    public void setIdGenerator(IDGenerator idGen);

    /*
    public void index(DocumentBase db, String repositoryId);
    */

    /*Returns the id of the repository in which the document should be stored*/
    public String getRepositoryForStorage();

    /**Sets the id of the repository in which the document should be stored*/
    public void setRepositoryForStorage(String repoId);
}
