/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.extended;

import net.sourceforge.chaperon.common.Decoder;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.extended.Pattern;

public class SingleCharacter
extends Pattern {
    private char character;

    public SingleCharacter() {
    }

    public SingleCharacter(char character) {
        this.setCharacter(character);
    }

    public void setCharacter(char character) {
        this.character = character;
    }

    public void setCharacterAsString(String character) {
        this.character = character.startsWith("#") && character.length() > 1 ? (char)Integer.parseInt(character.substring(1)) : character.charAt(0);
    }

    public char getCharacter() {
        return this.character;
    }

    public String getCharacterAsString() {
        return String.valueOf(this.character);
    }

    public void update() {
        super.update();
        this.addFirstPattern(this);
        this.addLastPattern(this);
    }

    public char[] getLimits() {
        return new char[]{this.getCharacter()};
    }

    public boolean contains(char minimum, char maximum) {
        return this.getCharacter() == minimum && this.getCharacter() == maximum;
    }

    public boolean contains(char c) {
        return c == this.character;
    }

    public String getSymbol() {
        return null;
    }

    public String toString() {
        return Decoder.toChar(this.character) + "[" + this.index + "]";
    }

    public Object clone() {
        SingleCharacter clone = new SingleCharacter();
        clone.setCharacter(this.getCharacter());
        return clone;
    }

    public Violations validate() {
        Violations violations = new Violations();
        return violations;
    }
}

