/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.i18n;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;

public class Resources {
    private static final Random RANDOM = new Random();
    private final Locale m_locale;
    private ResourceBundle m_bundle;
    private String m_baseName;
    private ClassLoader m_classLoader;

    public Resources(String baseName) {
        this(baseName, Locale.getDefault(), null);
    }

    public Resources(String baseName, ClassLoader classLoader) {
        this(baseName, Locale.getDefault(), classLoader);
    }

    public Resources(String baseName, Locale locale) {
        this(baseName, locale, null);
    }

    public Resources(String baseName, Locale locale, ClassLoader classLoader) {
        if (null == baseName) {
            throw new NullPointerException("baseName property is null");
        }
        if (null == locale) {
            throw new NullPointerException("locale property is null");
        }
        this.m_baseName = baseName;
        this.m_locale = locale;
        this.m_classLoader = classLoader;
    }

    public boolean getBoolean(String key, boolean defaultValue) throws MissingResourceException {
        try {
            return this.getBoolean(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        String value = bundle.getString(key);
        return value.equalsIgnoreCase("true");
    }

    public byte getByte(String key, byte defaultValue) throws MissingResourceException {
        try {
            return this.getByte(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public byte getByte(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        String value = bundle.getString(key);
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a byte value but got " + value, "java.lang.String", key);
        }
    }

    public char getChar(String key, char defaultValue) throws MissingResourceException {
        try {
            return this.getChar(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public char getChar(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        String value = bundle.getString(key);
        if (1 == value.length()) {
            return value.charAt(0);
        }
        throw new MissingResourceException("Expecting a char value but got " + value, "java.lang.String", key);
    }

    public short getShort(String key, short defaultValue) throws MissingResourceException {
        try {
            return this.getShort(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public short getShort(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        String value = bundle.getString(key);
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a short value but got " + value, "java.lang.String", key);
        }
    }

    public int getInteger(String key, int defaultValue) throws MissingResourceException {
        try {
            return this.getInteger(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public int getInteger(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        String value = bundle.getString(key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a integer value but got " + value, "java.lang.String", key);
        }
    }

    public long getLong(String key, long defaultValue) throws MissingResourceException {
        try {
            return this.getLong(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public long getLong(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        String value = bundle.getString(key);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a long value but got " + value, "java.lang.String", key);
        }
    }

    public float getFloat(String key, float defaultValue) throws MissingResourceException {
        try {
            return this.getFloat(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public float getFloat(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        String value = bundle.getString(key);
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a float value but got " + value, "java.lang.String", key);
        }
    }

    public double getDouble(String key, double defaultValue) throws MissingResourceException {
        try {
            return this.getDouble(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public double getDouble(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        String value = bundle.getString(key);
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            throw new MissingResourceException("Expecting a double value but got " + value, "java.lang.String", key);
        }
    }

    public Date getDate(String key, Date defaultValue) throws MissingResourceException {
        try {
            return this.getDate(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public Date getDate(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        String value = bundle.getString(key);
        try {
            DateFormat format = DateFormat.getDateInstance(2, this.m_locale);
            return format.parse(value);
        }
        catch (ParseException pe) {
            throw new MissingResourceException("Expecting a date value but got " + value, "java.lang.String", key);
        }
    }

    public Date getTime(String key, Date defaultValue) throws MissingResourceException {
        try {
            return this.getTime(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public Date getTime(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        String value = bundle.getString(key);
        try {
            DateFormat format = DateFormat.getTimeInstance(2, this.m_locale);
            return format.parse(value);
        }
        catch (ParseException pe) {
            throw new MissingResourceException("Expecting a time value but got " + value, "java.lang.String", key);
        }
    }

    public Date getDateTime(String key, Date defaultValue) throws MissingResourceException {
        try {
            return this.getDateTime(key);
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    public Date getDateTime(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        String value = bundle.getString(key);
        try {
            DateFormat format = DateFormat.getDateTimeInstance(2, 2, this.m_locale);
            return format.parse(value);
        }
        catch (ParseException pe) {
            throw new MissingResourceException("Expecting a time value but got " + value, "java.lang.String", key);
        }
    }

    public String getString(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        return bundle.getString(key);
    }

    public String getString(String key, Object arg1) {
        Object[] args = new Object[]{arg1};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4, arg5};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4, arg5, arg6};
        return this.format(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7};
        return this.format(key, args);
    }

    public String format(String key, Object[] args) {
        try {
            String pattern = this.getPatternString(key);
            return MessageFormat.format(pattern, args);
        }
        catch (MissingResourceException mre) {
            StringBuffer sb = new StringBuffer();
            sb.append("Unknown resource. Bundle: '");
            sb.append(this.m_baseName);
            sb.append("' Key: '");
            sb.append(key);
            sb.append("' Args: '");
            for (int i = 0; i < args.length; ++i) {
                if (0 != i) {
                    sb.append("', '");
                }
                sb.append(args[i]);
            }
            sb.append("' Reason: ");
            sb.append(mre);
            return sb.toString();
        }
    }

    public final ResourceBundle getBundle() throws MissingResourceException {
        if (null == this.m_bundle) {
            ClassLoader classLoader = this.m_classLoader;
            if (null == classLoader) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            this.m_bundle = null != classLoader ? ResourceBundle.getBundle(this.m_baseName, this.m_locale, classLoader) : ResourceBundle.getBundle(this.m_baseName, this.m_locale);
        }
        return this.m_bundle;
    }

    private String getPatternString(String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle();
        Object object = bundle.getObject(key);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            String[] strings = (String[])object;
            return strings[RANDOM.nextInt(strings.length)];
        }
        throw new MissingResourceException("Unable to find resource of appropriate type.", "java.lang.String", key);
    }
}

