/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.avalon.excalibur.datasource.AbstractJdbcConnection;
import org.apache.avalon.excalibur.datasource.NoValidConnectionException;
import org.apache.avalon.excalibur.datasource.ProxiedJdbcConnection;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class JdbcConnectionFactory
extends AbstractLogEnabled
implements ObjectFactory {
    private final String m_dburl;
    private final String m_username;
    private final String m_password;
    private final boolean m_autoCommit;
    private final String m_keepAlive;
    private final int m_keepAliveAge;
    private final String m_connectionClass;
    private Class m_class;
    private static final String DEFAULT_KEEPALIVE = "SELECT 1";
    private static final String ORACLE_KEEPALIVE = "SELECT 1 FROM DUAL";
    private Connection m_firstConnection;
    static /* synthetic */ Class class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$LogEnabled;
    static /* synthetic */ Class class$org$apache$avalon$excalibur$datasource$PoolSettable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Disposable;

    public JdbcConnectionFactory(String url, String username, String password, boolean autoCommit, boolean oradb) {
        this(url, username, password, autoCommit, oradb, null);
    }

    public JdbcConnectionFactory(String url, String username, String password, boolean autoCommit, boolean oradb, String connectionClass) {
        this(url, username, password, autoCommit, oradb ? ORACLE_KEEPALIVE : DEFAULT_KEEPALIVE, connectionClass);
    }

    public JdbcConnectionFactory(String url, String username, String password, boolean autoCommit, String keepAlive, String connectionClass) {
        this(url, username, password, autoCommit, keepAlive, 5000, connectionClass);
    }

    public JdbcConnectionFactory(String url, String username, String password, boolean autoCommit, String keepAlive, int keepAliveAge, String connectionClass) {
        this.m_dburl = url;
        this.m_username = username;
        this.m_password = password;
        this.m_autoCommit = autoCommit;
        this.m_keepAlive = keepAlive;
        this.m_keepAliveAge = keepAliveAge;
        this.m_connectionClass = connectionClass;
        try {
            this.m_firstConnection = null == this.m_username ? DriverManager.getConnection(this.m_dburl) : DriverManager.getConnection(this.m_dburl, this.m_username, this.m_password);
            this.init();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void init() throws Exception {
        String className = this.m_connectionClass;
        this.m_class = null == className ? (class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection == null ? (class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection = JdbcConnectionFactory.class$("org.apache.avalon.excalibur.datasource.AbstractJdbcConnection")) : class$org$apache$avalon$excalibur$datasource$AbstractJdbcConnection) : Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    public Object newInstance() throws Exception {
        Connection jdbcConnection = null;
        Connection connection = this.m_firstConnection;
        if (null == connection) {
            connection = null == this.m_username ? DriverManager.getConnection(this.m_dburl) : DriverManager.getConnection(this.m_dburl, this.m_username, this.m_password);
        } else {
            this.m_firstConnection = null;
        }
        if (null == this.m_class) {
            try {
                this.init();
            }
            catch (Exception e) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Exception in JdbcConnectionFactory.newInstance:", (Throwable)e);
                }
                throw new NoValidConnectionException("No valid JdbcConnection class available");
            }
        }
        try {
            jdbcConnection = this.getProxy(connection, this.m_keepAlive, this.m_keepAliveAge);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Exception in JdbcConnectionFactory.newInstance:", (Throwable)e);
            }
            throw new NoValidConnectionException(e.getMessage());
        }
        ContainerUtil.enableLogging((Object)jdbcConnection, (Logger)this.getLogger().getChildLogger("conn"));
        if (jdbcConnection.getAutoCommit() != this.m_autoCommit) {
            jdbcConnection.setAutoCommit(this.m_autoCommit);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JdbcConnection object created");
        }
        return jdbcConnection;
    }

    public Class getCreatedClass() {
        return this.m_class;
    }

    public void decommission(Object object) throws Exception {
        if (object instanceof Disposable) {
            ((Disposable)object).dispose();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("JdbcConnection object disposed");
            }
        }
    }

    private Connection getProxy(Connection conn, String keepAlive, int keepAliveAge) {
        ProxiedJdbcConnection handler = null;
        try {
            Constructor builder = this.m_class.getConstructor(class$java$sql$Connection == null ? (class$java$sql$Connection = JdbcConnectionFactory.class$("java.sql.Connection")) : class$java$sql$Connection, class$java$lang$String == null ? (class$java$lang$String = JdbcConnectionFactory.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
            handler = (ProxiedJdbcConnection)builder.newInstance(conn, keepAlive, new Integer(keepAliveAge));
        }
        catch (Exception e) {
            String msg = "Could not create the proper invocation handler, defaulting to AbstractJdbcConnection";
            this.getLogger().error("Could not create the proper invocation handler, defaulting to AbstractJdbcConnection", (Throwable)e);
            handler = new AbstractJdbcConnection(conn, keepAlive, keepAliveAge);
        }
        Connection connection = (Connection)Proxy.newProxyInstance(this.m_class.getClassLoader(), new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = JdbcConnectionFactory.class$("java.sql.Connection")) : class$java$sql$Connection, class$org$apache$avalon$framework$logger$LogEnabled == null ? (class$org$apache$avalon$framework$logger$LogEnabled = JdbcConnectionFactory.class$("org.apache.avalon.framework.logger.LogEnabled")) : class$org$apache$avalon$framework$logger$LogEnabled, class$org$apache$avalon$excalibur$datasource$PoolSettable == null ? (class$org$apache$avalon$excalibur$datasource$PoolSettable = JdbcConnectionFactory.class$("org.apache.avalon.excalibur.datasource.PoolSettable")) : class$org$apache$avalon$excalibur$datasource$PoolSettable, class$org$apache$avalon$framework$activity$Disposable == null ? (class$org$apache$avalon$framework$activity$Disposable = JdbcConnectionFactory.class$("org.apache.avalon.framework.activity.Disposable")) : class$org$apache$avalon$framework$activity$Disposable}, (InvocationHandler)handler);
        handler.setProxiedConnection(connection);
        return connection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

