/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;

public class TypeDeclarationPattern
extends JavaSearchPattern
implements IIndexConstants {
    public char[] simpleName;
    public char[] pkg;
    public char[][] enclosingTypeNames;
    public char classOrInterface;
    protected static char[][] CATEGORIES = new char[][]{IIndexConstants.TYPE_DECL};

    public static char[] createIndexKey(char[] typeName, char[] packageName, char[][] enclosingTypeNames, char classOrInterface) {
        int typeNameLength = typeName == null ? 0 : typeName.length;
        int packageLength = packageName == null ? 0 : packageName.length;
        int enclosingNamesLength = 0;
        if (enclosingTypeNames != null) {
            int i = 0;
            int length = enclosingTypeNames.length;
            while (i < length) {
                enclosingNamesLength += enclosingTypeNames[i].length;
                if (++i >= length) continue;
                ++enclosingNamesLength;
            }
        }
        char[] result = new char[typeNameLength + packageLength + enclosingNamesLength + 4];
        int pos = 0;
        if (typeNameLength > 0) {
            System.arraycopy(typeName, 0, result, pos, typeNameLength);
            pos += typeNameLength;
        }
        result[pos++] = 47;
        if (packageLength > 0) {
            System.arraycopy(packageName, 0, result, pos, packageLength);
            pos += packageLength;
        }
        result[pos++] = 47;
        if (enclosingNamesLength > 0) {
            int i = 0;
            int length = enclosingTypeNames.length;
            while (i < length) {
                char[] enclosingName = enclosingTypeNames[i];
                int itsLength = enclosingName.length;
                System.arraycopy(enclosingName, 0, result, pos, itsLength);
                pos += itsLength;
                if (++i >= length) continue;
                result[pos++] = 46;
            }
        }
        result[pos++] = 47;
        result[pos] = classOrInterface;
        return result;
    }

    public TypeDeclarationPattern(char[] pkg, char[][] enclosingTypeNames, char[] simpleName, char classOrInterface, int matchRule) {
        this(matchRule);
        char[] cArray = this.pkg = this.isCaseSensitive() ? pkg : CharOperation.toLowerCase(pkg);
        if (this.isCaseSensitive() || enclosingTypeNames == null) {
            this.enclosingTypeNames = enclosingTypeNames;
        } else {
            int length = enclosingTypeNames.length;
            this.enclosingTypeNames = new char[length][];
            int i = 0;
            while (i < length) {
                this.enclosingTypeNames[i] = CharOperation.toLowerCase(enclosingTypeNames[i]);
                ++i;
            }
        }
        this.simpleName = this.isCaseSensitive() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.classOrInterface = classOrInterface;
        this.mustResolve = this.pkg != null && this.enclosingTypeNames != null;
    }

    TypeDeclarationPattern(int matchRule) {
        super(8, matchRule);
    }

    public void decodeIndexKey(char[] key) {
        char[] names;
        int slash = CharOperation.indexOf('/', key, 0);
        this.simpleName = CharOperation.subarray(key, 0, slash);
        int start = slash + 1;
        this.pkg = (slash = CharOperation.indexOf('/', key, start)) == start ? CharOperation.NO_CHAR : CharOperation.subarray(key, start, slash);
        start = slash + 1;
        this.enclosingTypeNames = (slash = CharOperation.indexOf('/', key, start)) == start ? CharOperation.NO_CHAR_CHAR : (CharOperation.equals(IIndexConstants.ONE_ZERO, names = CharOperation.subarray(key, start, slash)) ? IIndexConstants.ONE_ZERO_CHAR : CharOperation.splitOn('.', names));
        this.classOrInterface = key[key.length - 1];
    }

    public SearchPattern getBlankPattern() {
        return new TypeDeclarationPattern(8);
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        TypeDeclarationPattern pattern = (TypeDeclarationPattern)decodedPattern;
        switch (this.classOrInterface) {
            case 'C': 
            case 'I': {
                if (this.classOrInterface == pattern.classOrInterface) break;
                return false;
            }
        }
        if (!this.matchesName(this.simpleName, pattern.simpleName)) {
            return false;
        }
        if (this.pkg != null && !CharOperation.equals(this.pkg, pattern.pkg, this.isCaseSensitive())) {
            return false;
        }
        if (this.enclosingTypeNames != null) {
            if (this.enclosingTypeNames.length == 0) {
                return pattern.enclosingTypeNames.length == 0;
            }
            if (this.enclosingTypeNames.length == 1 && pattern.enclosingTypeNames.length == 1) {
                return CharOperation.equals(this.enclosingTypeNames[0], pattern.enclosingTypeNames[0], this.isCaseSensitive());
            }
            if (pattern.enclosingTypeNames == IIndexConstants.ONE_ZERO_CHAR) {
                return true;
            }
            return CharOperation.equals(this.enclosingTypeNames, pattern.enclosingTypeNames, this.isCaseSensitive());
        }
        return true;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.simpleName;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 1: {
                break;
            }
            case 0: {
                if (this.simpleName != null) {
                    matchRule = matchRule - 0 + 1;
                    key = this.pkg == null ? CharOperation.append(this.simpleName, '/') : CharOperation.concat(this.simpleName, '/', this.pkg, '/', CharOperation.NO_CHAR);
                    break;
                }
                matchRule = matchRule - 0 + 2;
            }
            case 2: {
                if (this.pkg == null) {
                    if (this.simpleName == null) {
                        if (this.classOrInterface != 'C' && this.classOrInterface != 'I') break;
                        key = new char[]{IIndexConstants.ONE_STAR[0], '/', this.classOrInterface};
                        break;
                    }
                    if (this.simpleName[this.simpleName.length - 1] == '*') break;
                    key = CharOperation.concat(this.simpleName, IIndexConstants.ONE_STAR, '/');
                    break;
                }
                key = CharOperation.concat(this.simpleName == null ? IIndexConstants.ONE_STAR : this.simpleName, '/', this.pkg, '/', IIndexConstants.ONE_STAR);
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        switch (this.classOrInterface) {
            case 'C': {
                buffer.append("ClassDeclarationPattern: pkg<");
                break;
            }
            case 'I': {
                buffer.append("InterfaceDeclarationPattern: pkg<");
                break;
            }
            default: {
                buffer.append("TypeDeclarationPattern: pkg<");
            }
        }
        if (this.pkg != null) {
            buffer.append(this.pkg);
        } else {
            buffer.append("*");
        }
        buffer.append(">, enclosing<");
        if (this.enclosingTypeNames != null) {
            int i = 0;
            while (i < this.enclosingTypeNames.length) {
                buffer.append(this.enclosingTypeNames[i]);
                if (i < this.enclosingTypeNames.length - 1) {
                    buffer.append('.');
                }
                ++i;
            }
        } else {
            buffer.append("*");
        }
        buffer.append(">, type<");
        if (this.simpleName != null) {
            buffer.append(this.simpleName);
        } else {
            buffer.append("*");
        }
        buffer.append(">, ");
        switch (this.getMatchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        if (this.isCaseSensitive()) {
            buffer.append("case sensitive");
        } else {
            buffer.append("case insensitive");
        }
        return buffer.toString();
    }
}

