/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.jsp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.jsp.JSPEngine;
import weblogic.servlet.internal.ServletContextImpl;
import weblogic.servlet.internal.ServletOutputStreamImpl;
import weblogic.servlet.internal.ServletResponseImpl;

public class JSPEngineImplWLS
extends AbstractLogEnabled
implements JSPEngine,
Parameterizable,
ThreadSafe {
    public static final String INC_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String CONFIG_SERVLET_NAME = "servlet-name";
    public static final String DEFAULT_SERVLET_NAME = "*.jsp";
    String servletName = "*.jsp";

    public void parameterize(Parameters params) throws ParameterException {
        this.servletName = params.getParameter(CONFIG_SERVLET_NAME, DEFAULT_SERVLET_NAME);
    }

    public byte[] executeJSP(String url, HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServletContext servletContext) throws IOException, ServletException, Exception {
        byte[] bytes = null;
        HttpServletRequest request = servletRequest;
        String inc_servlet_path_was = (String)servletRequest.getAttribute(INC_SERVLET_PATH);
        request.setAttribute(INC_SERVLET_PATH, (Object)url);
        MyWLSResponse response = new MyWLSResponse(servletResponse, (ServletContextImpl)servletContext);
        RequestDispatcher rd = servletContext.getNamedDispatcher(this.servletName);
        if (rd != null) {
            rd.include((ServletRequest)request, (ServletResponse)response);
            response.flushBuffer();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("JSP response: " + response.getResponseContentAsString());
            }
            bytes = response.getResponseContentAsByteArray();
            if (inc_servlet_path_was != null) {
                servletRequest.setAttribute(INC_SERVLET_PATH, (Object)inc_servlet_path_was);
            }
        } else {
            this.getLogger().error("Specify a correct servlet-name " + this.servletName);
        }
        return bytes;
    }

    static class MyWLSResponse
    extends ServletResponseImpl {
        HttpServletResponse response;
        ByteArrayOutputStream baos;
        ServletOutputStreamImpl wlsOutputStream;

        public MyWLSResponse(HttpServletResponse response, ServletContextImpl servlet_context) {
            super(servlet_context);
            this.response = response;
            this.baos = new ByteArrayOutputStream();
            this.wlsOutputStream = new ServletOutputStreamImpl(this.baos);
            this.setOutputStream(this.wlsOutputStream);
            this.wlsOutputStream.setImpl((ServletResponseImpl)this);
        }

        public void flushBuffer() throws IOException {
            super.flushBuffer();
            this.baos.flush();
        }

        public byte[] getResponseContentAsByteArray() {
            int i;
            byte[] baos_arr = this.baos.toByteArray();
            int baos_arr_length = baos_arr.length;
            boolean matched = false;
            int I_MAX = 8192;
            int MATCH_0d = 13;
            int MATCH_0a = 10;
            int MATCH_FIRST = 60;
            int MATCH_SECOND = 63;
            int MATCH_THIRD = 120;
            int MATCH_FOURTH = 109;
            int MATCH_FIFTH = 108;
            int MATCH_COUNT = 5;
            for (i = 0; i + 5 < baos_arr_length && i < 8192 && !matched; i += 2) {
                boolean bl = matched = baos_arr[i] == 60 && baos_arr[i + 1] == 63 && baos_arr[i + 2] == 120 && baos_arr[i + 3] == 109 && baos_arr[i + 4] == 108;
                if (matched) break;
                boolean bl2 = matched = baos_arr[i] == 13 && baos_arr[i + 1] == 10 && baos_arr[i + 2] == 13 && baos_arr[i + 3] == 10 && baos_arr[i + 4] == 60;
                if (!matched) continue;
                i += 4;
                break;
            }
            if (matched && i > 0) {
                int baos_arr_new_length = baos_arr_length - i;
                byte[] new_baos_arr = new byte[baos_arr_new_length];
                System.arraycopy(baos_arr, i, new_baos_arr, 0, baos_arr_new_length);
                baos_arr = new_baos_arr;
            }
            return baos_arr;
        }

        public String getResponseContentAsString() {
            String s = new String(this.getResponseContentAsByteArray());
            return s;
        }

        public String getCharacterEncoding() {
            return this.response.getCharacterEncoding();
        }

        public Locale getLocale() {
            return this.response.getLocale();
        }

        public void addCookie(Cookie cookie) {
            this.response.addCookie(cookie);
        }

        public boolean containsHeader(String s) {
            return this.response.containsHeader(s);
        }

        public String encodeUrl(String s) {
            return this.response.encodeUrl(s);
        }

        public String encodeURL(String s) {
            return this.response.encodeURL(s);
        }

        public String encodeRedirectUrl(String s) {
            return this.response.encodeRedirectUrl(s);
        }

        public String encodeRedirectURL(String s) {
            return this.response.encodeRedirectURL(s);
        }

        public void sendError(int i, String s) throws IOException {
            this.response.sendError(i, s);
        }

        public void sendError(int i) throws IOException {
            this.response.sendError(i);
        }

        public void sendRedirect(String s) throws IOException {
            this.response.sendRedirect(s);
        }

        public void setDateHeader(String s, long l) {
            this.response.setDateHeader(s, l);
        }

        public void addDateHeader(String s, long l) {
            this.response.addDateHeader(s, l);
        }

        public void setHeader(String s, String s1) {
            this.response.setHeader(s, s1);
        }

        public void addHeader(String s, String s1) {
            this.response.addHeader(s, s1);
        }

        public void setIntHeader(String s, int i) {
            this.response.setIntHeader(s, i);
        }

        public void addIntHeader(String s, int i) {
            this.response.addIntHeader(s, i);
        }

        public void setStatus(int i) {
            this.response.setStatus(i);
        }

        public void setStatus(int i, String s) {
            this.response.setStatus(i, s);
        }
    }
}

