/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Cleanup
extends SvnCommand {
    private File path = null;
    private boolean failonerror = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws SvnAntException {
        if (this.path == null) return;
        if (this.path.exists()) {
            try {
                this.svnClient.cleanup(this.path);
                return;
            }
            catch (SVNClientException sVNClientException) {
                if (!this.failonerror) return;
                throw new SvnAntException("Can't cleanup directory " + this.path.getAbsolutePath(), sVNClientException);
            }
        } else {
            if (!this.failonerror) return;
            throw new SvnAntException("Directory doesn't exist " + this.path.getAbsolutePath());
        }
    }

    public void setDir(File file) {
        this.path = file;
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.path == null) {
            throw new SvnAntValidationException("dir must be set");
        }
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }
}

