/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import java.io.File;
import net.sf.pizzacompiler.compiler.Convert;
import net.sf.pizzacompiler.compiler.Name;

class ClassFileUtil {
    static final int JAVA_MAGIC = -889275714;
    static final int JAVA_MAJOR_VERSION = 45;
    static final int JAVA_MINOR_VERSION = 3;
    static final int JAVA_MAJOR_VERSION_MIN = 45;
    static final int JAVA_MINOR_VERSION_MIN = 3;
    static final int CONSTANT_Utf8 = 1;
    static final int CONSTANT_Unicode = 2;
    static final int CONSTANT_Integer = 3;
    static final int CONSTANT_Float = 4;
    static final int CONSTANT_Long = 5;
    static final int CONSTANT_Double = 6;
    static final int CONSTANT_Class = 7;
    static final int CONSTANT_String = 8;
    static final int CONSTANT_Fieldref = 9;
    static final int CONSTANT_Methodref = 10;
    static final int CONSTANT_InterfaceMethodref = 11;
    static final int CONSTANT_NameandType = 12;
    static final Name ConstantValueS = Name.fromString("ConstantValue");
    static final Name LineNumberTableS = Name.fromString("LineNumberTable");
    static final Name LocalVariableTableS = Name.fromString("LocalVariableTable");
    static final Name CodeS = Name.fromString("Code");
    static final Name ExceptionsS = Name.fromString("Exceptions");
    static final Name SourceFileS = Name.fromString("SourceFile");
    static final Name InnerClassesS = Name.fromString("InnerClasses");
    static final Name SyntheticS = Name.fromString("Synthetic");
    static final Name DeprecatedS = Name.fromString("Deprecated");
    static final Name PizzaS = Name.fromString("Pizza");
    static final Name PizzaCaseS = Name.fromString("PizzaCase");
    static final Name BYTEsig = Name.fromString("B");
    static final Name SHORTsig = Name.fromString("S");
    static final Name CHARsig = Name.fromString("C");
    static final Name INTsig = Name.fromString("I");
    static final Name LONGsig = Name.fromString("J");
    static final Name FLOATsig = Name.fromString("F");
    static final Name DOUBLEsig = Name.fromString("D");
    static final Name BOOLEANsig = Name.fromString("Z");
    static final Name VOIDsig = Name.fromString("V");
    static final Name CLASSsig = Name.fromString("L");
    static final Name TYPEVARsig = Name.fromString("A");
    static final Name ARRAYsig = Name.fromString("[");
    static final Name ARGBEGINsig = Name.fromString("(");
    static final Name ARGENDsig = Name.fromString(")");
    static final Name PARBEGINsig = Name.fromString("<");
    static final Name PARENDsig = Name.fromString(">");
    static final Name THROWSBEGINsig = Name.fromString("!");
    static final Name THROWSENDsig = Name.fromString("!");

    static byte[] internalize(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[n + i];
            byArray2[i] = n3 == 47 ? 46 : n3;
        }
        return byArray2;
    }

    static byte[] externalize(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[n + i];
            byArray2[i] = n3 == 46 ? 47 : n3;
        }
        return byArray2;
    }

    static Name internalizeFileName(String string) {
        byte[] byArray = Convert.string2ascii(string.replace(File.separatorChar, '.'));
        return Name.fromAscii(byArray, 0, byArray.length);
    }

    static String externalizeFileName(Name name) {
        if (name == null || name.len == 0) {
            return ".";
        }
        byte[] byArray = name.toAscii();
        String string = Convert.ascii2string(byArray, 0, byArray.length);
        return string.replace('.', File.separatorChar);
    }

    ClassFileUtil() {
    }
}

