/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.components.elementprocessor.ElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BaseElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Sheet;
import org.apache.cocoon.components.elementprocessor.types.Attribute;
import org.apache.cocoon.components.elementprocessor.types.BooleanConverter;
import org.apache.cocoon.components.elementprocessor.types.BooleanResult;

public class EPSheet
extends BaseElementProcessor {
    private Sheet _sheet;
    private BooleanResult _display_formulas = null;
    private BooleanResult _hide_zero = null;
    private BooleanResult _hide_grid = null;
    private BooleanResult _hide_col_header = null;
    private BooleanResult _hide_row_header = null;
    private BooleanResult _display_outlines = null;
    private BooleanResult _outline_symbols_below = null;
    private BooleanResult _outline_symbols_right = null;
    private static final String _display_formulas_attribute = "DisplayFormulas";
    private static final String _hide_zero_attribute = "HideZero";
    private static final String _hide_grid_attribute = "HideGrid";
    private static final String _hide_col_header_attribute = "HideColHeader";
    private static final String _hide_row_header_attribute = "HideRowHeader";
    private static final String _display_outlines_attribute = "DisplayOutlines";
    private static final String _outline_symbols_below_attribute = "OutlineSymbolsBelow";
    private static final String _outline_symbols_right_attribute = "OutlineSymbolsRight";

    public EPSheet() {
        super(null);
    }

    public void initialize(Attribute[] attributes, ElementProcessor parent) throws IOException {
        super.initialize(attributes, parent);
        try {
            this._sheet = new Sheet(this.getWorkbook());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CascadingIOException(e.getMessage(), (Throwable)e);
        }
    }

    public void endProcessing() throws IOException {
        this._sheet.assignBlanksToRegions();
    }

    protected Sheet getSheet() {
        return this._sheet;
    }

    public boolean getDisplayFormulas() throws IOException {
        if (this._display_formulas == null) {
            this._display_formulas = BooleanConverter.extractBoolean(this.getValue(_display_formulas_attribute));
        }
        return this._display_formulas.booleanValue();
    }

    public boolean getHideZero() throws IOException {
        if (this._hide_zero == null) {
            this._hide_zero = BooleanConverter.extractBoolean(this.getValue(_hide_zero_attribute));
        }
        return this._hide_zero.booleanValue();
    }

    public boolean getHideGrid() throws IOException {
        if (this._hide_grid == null) {
            this._hide_grid = BooleanConverter.extractBoolean(this.getValue(_hide_grid_attribute));
        }
        return this._hide_grid.booleanValue();
    }

    public boolean getHideColHeader() throws IOException {
        if (this._hide_col_header == null) {
            this._hide_col_header = BooleanConverter.extractBoolean(this.getValue(_hide_col_header_attribute));
        }
        return this._hide_col_header.booleanValue();
    }

    public boolean getHideRowHeader() throws IOException {
        if (this._hide_row_header == null) {
            this._hide_row_header = BooleanConverter.extractBoolean(this.getValue(_hide_row_header_attribute));
        }
        return this._hide_row_header.booleanValue();
    }

    public boolean getDisplayOutlines() throws IOException {
        if (this._display_outlines == null) {
            this._display_outlines = BooleanConverter.extractBoolean(this.getValue(_display_outlines_attribute));
        }
        return this._display_outlines.booleanValue();
    }

    public boolean getOutlineSymbolsBelow() throws IOException {
        if (this._outline_symbols_below == null) {
            this._outline_symbols_below = BooleanConverter.extractBoolean(this.getValue(_outline_symbols_below_attribute));
        }
        return this._outline_symbols_below.booleanValue();
    }

    public boolean getOutlineSymbolsRight() throws IOException {
        if (this._outline_symbols_right == null) {
            this._outline_symbols_right = BooleanConverter.extractBoolean(this.getValue(_outline_symbols_right_attribute));
        }
        return this._outline_symbols_right.booleanValue();
    }
}

