/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.programming.java;

import EDU.oswego.cs.dl.util.concurrent.CountDown;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.language.programming.CompilerError;
import org.apache.cocoon.components.language.programming.java.AbstractJavaCompiler;
import org.apache.cocoon.components.thread.RunnableManager;

public class Jikes
extends AbstractJavaCompiler
implements Serviceable {
    static final int OUTPUT_BUFFER_SIZE = 1024;
    static final int BUFFER_SIZE = 512;
    private ServiceManager m_serviceManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
    }

    protected String[] toStringArray(List arguments) {
        int i;
        for (i = 0; i < arguments.size(); ++i) {
            String arg = (String)arguments.get(i);
            if (!arg.equals("-sourcepath")) continue;
            arguments.remove(i);
            arguments.remove(i);
            break;
        }
        String[] args = new String[arguments.size() + 1];
        for (i = 0; i < arguments.size(); ++i) {
            args[i] = (String)arguments.get(i);
        }
        args[i] = this.file;
        return args;
    }

    public boolean compile() throws IOException {
        int exitValue;
        ArrayList<String> args = new ArrayList<String>();
        args.add("jikes");
        args.add("+E");
        args.add("-nowarn");
        ByteArrayOutputStream tmpErr = new ByteArrayOutputStream(1024);
        try {
            Process p = Runtime.getRuntime().exec(this.toStringArray(this.fillArguments(args)));
            BufferedInputStream compilerErr = new BufferedInputStream(p.getErrorStream());
            RunnableManager runnableManager = null;
            try {
                runnableManager = (RunnableManager)this.m_serviceManager.lookup(RunnableManager.ROLE);
            }
            catch (ServiceException se) {
                this.getLogger().error("Cannot get RunnableManager", (Throwable)se);
                throw new IOException("Cannot get RunnableManager");
            }
            CountDown done = new CountDown(1);
            StreamPumper errPumper = new StreamPumper(compilerErr, tmpErr, done);
            runnableManager.execute((Runnable)errPumper);
            this.m_serviceManager.release((Object)runnableManager);
            p.waitFor();
            exitValue = p.exitValue();
            done.acquire();
            compilerErr.close();
            p.destroy();
            tmpErr.close();
            this.errors = new ByteArrayInputStream(tmpErr.toByteArray());
        }
        catch (InterruptedException somethingHappened) {
            this.getLogger().debug("Jikes.compile():SomethingHappened", (Throwable)somethingHappened);
            return false;
        }
        return exitValue == 0 && tmpErr.size() == 0;
    }

    protected List parseStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = null;
        String line = null;
        StringBuffer buffer = null;
        while (true) {
            buffer = new StringBuffer();
            if (line == null) {
                line = input.readLine();
            }
            if (line == null) {
                return errors;
            }
            buffer.append(line);
            while ((line = input.readLine()) != null && (line.length() <= 0 || line.charAt(0) == ' ')) {
                buffer.append('\n');
                buffer.append(line);
            }
            if (errors == null) {
                errors = new ArrayList<CompilerError>();
            }
            errors.add(this.parseError(buffer.toString()));
        }
    }

    private CompilerError parseError(String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        String file = tokens.nextToken();
        if (file.length() == 1) {
            file = file + ":" + tokens.nextToken();
        }
        StringBuffer message = new StringBuffer();
        String type = "";
        int startline = 0;
        int startcolumn = 0;
        int endline = 0;
        int endcolumn = 0;
        try {
            startline = Integer.parseInt(tokens.nextToken());
            startcolumn = Integer.parseInt(tokens.nextToken());
            endline = Integer.parseInt(tokens.nextToken());
            endcolumn = Integer.parseInt(tokens.nextToken());
        }
        catch (Exception e) {
            message.append("Please ensure that you have your JDK's rt.jar listed in your classpath. Jikes needs it to operate.");
            type = "error";
            this.getLogger().error(message.toString(), (Throwable)e);
        }
        if ("".equals(message.toString())) {
            type = tokens.nextToken().trim().toLowerCase();
            message.append(tokens.nextToken("\n").substring(1).trim());
            while (tokens.hasMoreTokens()) {
                message.append("\n").append(tokens.nextToken());
            }
        }
        return new CompilerError(file, type.equals("error"), startline, startcolumn, endline, endcolumn, message.toString());
    }

    public String toString() {
        return "IBM Jikes Compiler";
    }

    private static class StreamPumper
    implements Runnable {
        private BufferedInputStream stream;
        private boolean endOfStream = false;
        private int SLEEP_TIME = 5;
        private OutputStream out;
        private CountDown m_done;

        public StreamPumper(BufferedInputStream is, OutputStream out, CountDown done) {
            this.stream = is;
            this.out = out;
            this.m_done = done;
        }

        public void pumpStream() throws IOException {
            byte[] buf = new byte[512];
            if (!this.endOfStream) {
                int bytesRead = this.stream.read(buf, 0, 512);
                if (bytesRead > 0) {
                    this.out.write(buf, 0, bytesRead);
                } else if (bytesRead == -1) {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                while (!this.endOfStream) {
                    this.pumpStream();
                    Thread.sleep(this.SLEEP_TIME);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_done.release();
        }
    }
}

