/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.auth;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.auth.Application;
import org.apache.cocoon.auth.ApplicationStore;
import org.apache.cocoon.auth.SecurityHandler;
import org.apache.cocoon.auth.User;
import org.apache.cocoon.auth.impl.AnonymousSecurityHandler;

public class StandardApplication
extends AbstractLogEnabled
implements Application,
Configurable,
Serviceable,
Disposable,
ThreadSafe {
    protected static final String HANDLER_CONFIG_PREFIX = SecurityHandler.class.getName() + '/';
    protected static final String STORE_CONFIG_PREFIX = ApplicationStore.class.getName() + '/';
    protected ServiceManager manager;
    protected SecurityHandler handler;
    protected final Map attributes = new HashMap();
    protected ApplicationStore store;

    public void service(ServiceManager aManager) throws ServiceException {
        this.manager = aManager;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        String handlerName = conf.getAttribute("security-handler", null);
        String storeName = conf.getAttribute("store", null);
        try {
            if (handlerName == null) {
                this.handler = new AnonymousSecurityHandler();
            } else {
                if (!handlerName.startsWith(HANDLER_CONFIG_PREFIX)) {
                    handlerName = HANDLER_CONFIG_PREFIX + handlerName;
                }
                this.handler = (SecurityHandler)this.manager.lookup(handlerName);
            }
            if (storeName != null) {
                if (!storeName.startsWith(STORE_CONFIG_PREFIX)) {
                    storeName = STORE_CONFIG_PREFIX + storeName;
                }
                this.store = (ApplicationStore)this.manager.lookup(storeName);
            }
        }
        catch (ServiceException se) {
            throw new ConfigurationException("Unable to look up component.", (Throwable)se);
        }
        this.configureAttributes(conf);
    }

    protected void configureAttributes(Configuration conf) {
        Configuration[] children = conf.getChildren();
        for (int i = 0; i < children.length; ++i) {
            String name = children[i].getName();
            String value = children[i].getValue(null);
            if (value == null || value.trim().length() <= 0) continue;
            this.setAttribute(name, value.trim());
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.store);
            if (!(this.handler instanceof AnonymousSecurityHandler)) {
                this.manager.release((Object)this.handler);
            }
            this.store = null;
            this.handler = null;
            this.manager = null;
        }
    }

    public SecurityHandler getSecurityHandler() {
        return this.handler;
    }

    public ApplicationStore getApplicationStore() {
        return this.store;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void userDidLogin(User user, Map context) {
    }

    public void userWillLogout(User user, Map context) {
    }

    public void userIsAccessing(User user) {
    }
}

