/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

public class ResizableContainer {
    private int pointer = -1;
    private int size = 0;
    private Object[] container;

    public ResizableContainer(int initialCapacity) {
        this.container = new Object[initialCapacity];
    }

    public void add(Object o) {
        this.set(++this.pointer, o);
    }

    public void set(int index, Object o) {
        this.adjustPointer(index);
        this.ensureCapacity(index + 1);
        this.container[index] = o;
        ++this.size;
    }

    public Object get(int index) {
        return index < this.container.length ? this.container[index] : null;
    }

    public int size() {
        return this.size;
    }

    private void adjustPointer(int newPointer) {
        this.pointer = Math.max(this.pointer, newPointer);
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.container.length;
        if (oldCapacity < minCapacity) {
            Object[] oldContainer = this.container;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.container = new Object[newCapacity];
            System.arraycopy(oldContainer, 0, this.container, 0, oldContainer.length);
        }
    }
}

