/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractJXPathModule;
import org.apache.cocoon.components.modules.input.JXPathHelper;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.w3c.dom.Document;

public class XMLFileModule
extends AbstractJXPathModule
implements Composable,
ThreadSafe {
    String staticConfLocation;
    Map documents;
    boolean reloadAll;
    boolean cacheAll;
    boolean cacheExpressions;
    String src;
    SourceResolver resolver;
    ComponentManager manager;
    private Map expressionCache;
    private Map expressionValuesCache;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        this.staticConfLocation = config.getLocation();
        this.reloadAll = config.getChild("reloadable").getValueAsBoolean(false);
        if (config.getChild("cachable", false) != null) {
            throw new ConfigurationException("Bzzt! Wrong spelling at " + config.getChild("cachable").getLocation() + ": please use 'cacheable', not 'cachable'");
        }
        this.cacheAll = config.getChild("cacheable").getValueAsBoolean(true);
        this.documents = Collections.synchronizedMap(new ReferenceMap());
        Configuration[] files = config.getChildren("file");
        for (int i = 0; i < files.length; ++i) {
            boolean reload = files[i].getAttributeAsBoolean("reloadable", this.reloadAll);
            boolean cache = files[i].getAttributeAsBoolean("cacheable", this.cacheAll);
            this.src = files[i].getAttribute("src");
            this.documents.put(this.src, new DocumentHelper(reload, cache, this.src, this));
        }
        this.cacheExpressions = config.getChild("cache-expressions").getValueAsBoolean(true);
        if (this.cacheExpressions) {
            this.expressionCache = new ReferenceMap(1, 1);
            this.expressionValuesCache = new ReferenceMap(1, 1);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.manager != null) {
            this.manager.release((Component)this.resolver);
            this.resolver = null;
            this.manager = null;
        }
        this.documents = null;
        this.expressionCache = null;
        this.expressionValuesCache = null;
    }

    private DocumentHelper getDocumentHelper(Configuration modeConf) throws ConfigurationException {
        boolean hasDynamicConf = false;
        Configuration fileConf = null;
        if (modeConf != null && modeConf.getChildren().length > 0) {
            fileConf = modeConf.getChild("file", false);
            if (fileConf == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Missing 'file' child element at " + modeConf.getLocation());
                }
            } else {
                hasDynamicConf = true;
            }
        }
        String src = this.src;
        if (hasDynamicConf) {
            src = fileConf.getAttribute("src");
        }
        if (src == null) {
            throw new ConfigurationException("No source specified" + (modeConf != null ? ", either dynamically in " + modeConf.getLocation() + ", or " : "") + " statically in " + this.staticConfLocation);
        }
        if (!this.documents.containsKey(src)) {
            boolean reload = this.reloadAll;
            boolean cache = this.cacheAll;
            if (hasDynamicConf) {
                reload = fileConf.getAttributeAsBoolean("reloadable", reload);
                cache = fileConf.getAttributeAsBoolean("cacheable", cache);
                if (fileConf.getAttribute("cachable", null) != null) {
                    throw new ConfigurationException("Bzzt! Wrong spelling at " + fileConf.getLocation() + ": please use 'cacheable', not 'cachable'");
                }
            }
            this.documents.put(src, new DocumentHelper(reload, cache, src, this));
        }
        return (DocumentHelper)this.documents.get(src);
    }

    protected Object getContextObject(Configuration modeConf, Map objectModel) throws ConfigurationException {
        DocumentHelper helper = this.getDocumentHelper(modeConf);
        try {
            return helper.getDocument(this.manager, this.resolver, this.getLogger());
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Error using source " + this.src + "\n" + e.getMessage(), (Throwable)e);
            }
            throw new ConfigurationException("Error using source " + this.src, (Throwable)e);
        }
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        return this.getAttribute(name, modeConf, objectModel, false);
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object result = this.getAttribute(name, modeConf, objectModel, true);
        return result != null ? (Object[])result : null;
    }

    private Object getAttribute(String name, Configuration modeConf, Map objectModel, boolean getValues) throws ConfigurationException {
        Object contextObj = this.getContextObject(modeConf, objectModel);
        if (modeConf != null) {
            name = modeConf.getChild("parameter").getValue(this.parameter != null ? this.parameter : name);
        }
        Object result = null;
        Map cache = null;
        boolean hasBeenCached = false;
        if (this.cacheExpressions && (hasBeenCached = (cache = this.getExpressionCache(getValues ? this.expressionValuesCache : this.expressionCache, contextObj)).containsKey(name))) {
            result = cache.get(name);
        }
        if (!hasBeenCached) {
            result = getValues ? JXPathHelper.getAttributeValues(name, modeConf, this.configuration, contextObj) : JXPathHelper.getAttribute(name, modeConf, this.configuration, contextObj);
            if (this.cacheExpressions) {
                cache.put(name, result);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("for " + name + " newly caching result " + result);
                }
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("for " + name + " result is " + result);
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("for " + name + " using cached result " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushCache() {
        if (this.cacheExpressions) {
            Map map = this.expressionCache;
            synchronized (map) {
                this.expressionCache.clear();
            }
            map = this.expressionValuesCache;
            synchronized (map) {
                this.expressionValuesCache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getExpressionCache(Map cache, Object key) {
        Map map = cache;
        synchronized (map) {
            Map map2 = (Map)cache.get(key);
            if (map2 == null) {
                map2 = Collections.synchronizedMap(new HashMap());
                cache.put(key, map2);
            }
            return map2;
        }
    }

    protected static class DocumentHelper {
        private boolean reloadable;
        private boolean cacheable;
        private String uri;
        private SourceValidity validity;
        private Document document;
        private XMLFileModule instance;

        public DocumentHelper(boolean reload, boolean cache, String src, XMLFileModule instance) {
            this.reloadable = reload;
            this.cacheable = cache;
            this.uri = src;
            this.instance = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Document getDocument(ComponentManager manager, SourceResolver resolver, Logger logger) throws Exception {
            Document dom;
            block16: {
                Source src = null;
                dom = null;
                try {
                    if (this.document == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Document not cached... Loading uri " + this.uri);
                        }
                        src = resolver.resolveURI(this.uri);
                        this.validity = src.getValidity();
                        this.document = SourceUtil.toDOM(src);
                    } else if (this.reloadable) {
                        int valid;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Document cached... checking validity of uri " + this.uri);
                        }
                        int n = valid = this.validity == null ? -1 : this.validity.isValid();
                        if (valid != 1) {
                            src = resolver.resolveURI(this.uri);
                            SourceValidity newValidity = src.getValidity();
                            if (valid == -1 || this.validity.isValid(newValidity) != 1) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Reloading document... uri " + this.uri);
                                }
                                this.validity = newValidity;
                                this.document = SourceUtil.toDOM(src);
                                this.instance.flushCache();
                            }
                        }
                    }
                    dom = this.document;
                    Object var9_8 = null;
                    if (src == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (src != null) {
                        resolver.release(src);
                    }
                    if (!this.cacheable) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Not caching document cached... uri " + this.uri);
                        }
                        this.validity = null;
                        this.document = null;
                    }
                    throw throwable;
                }
                resolver.release(src);
            }
            if (!this.cacheable) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Not caching document cached... uri " + this.uri);
                }
                this.validity = null;
                this.document = null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Done with document... uri " + this.uri);
            }
            return dom;
        }
    }
}

