/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.locking;

import org.apache.jcs.utils.locking.ReadWriteLock;

class RwLockHolder {
    private static final long UNUSED_TIME = 10000L;
    private final ReadWriteLock rwlock;
    int lcount = 1;
    long lastInactiveTime = -1L;

    RwLockHolder(ReadWriteLock rwlock) {
        this.rwlock = rwlock;
    }

    boolean removable(long now) {
        return this.lcount == 0 && this.lastInactiveTime > 0L && now - this.lastInactiveTime > 10000L;
    }

    public void readLock() throws InterruptedException {
        this.rwlock.readLock();
    }

    public void writeLock() throws InterruptedException {
        this.rwlock.writeLock();
    }

    public void done() {
        this.rwlock.done();
    }
}

