/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.batik.util.DoublyLinkedList;

public class RunnableQueue
implements Runnable {
    public static final RunnableQueueState RUNNING = new RunnableQueueState("Running");
    public static final RunnableQueueState SUSPENDING = new RunnableQueueState("Suspending");
    public static final RunnableQueueState SUSPENDED = new RunnableQueueState("Suspended");
    protected RunnableQueueState state;
    protected Object stateLock = new Object();
    protected DoublyLinkedList list = new DoublyLinkedList();
    protected int preemptCount = 0;
    protected RunHandler runHandler;
    protected Thread runnableQueueThread;
    private static int threadCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunnableQueue createRunnableQueue() {
        RunnableQueue runnableQueue;
        RunnableQueue runnableQueue2 = runnableQueue = new RunnableQueue();
        synchronized (runnableQueue2) {
            Thread thread = new Thread((Runnable)runnableQueue, "RunnableQueue-" + threadCount++);
            thread.setDaemon(true);
            thread.start();
            while (runnableQueue.getThread() == null) {
                try {
                    runnableQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return runnableQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object = this;
        synchronized (object) {
            this.runnableQueueThread = Thread.currentThread();
            this.notify();
        }
        try {
            try {}
            catch (InterruptedException throwable) {
                Object var7_8 = null;
                RunnableQueue runnableQueue = this;
                synchronized (runnableQueue) {
                    this.runnableQueueThread = null;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            RunnableQueue runnableQueue = this;
            synchronized (runnableQueue) {
                this.runnableQueueThread = null;
                throw throwable;
            }
        }
        while (!Thread.currentThread().isInterrupted()) {
            Runnable runnable;
            Object object2 = this.stateLock;
            synchronized (object2) {
                if (this.state != RUNNING) {
                    this.state = SUSPENDED;
                    this.stateLock.notifyAll();
                    this.executionSuspended();
                    while (this.state != RUNNING) {
                        this.state = SUSPENDED;
                        this.stateLock.wait();
                    }
                    this.executionResumed();
                }
            }
            object2 = this.list;
            synchronized (object2) {
                if (this.state == SUSPENDING) {
                    continue;
                }
                object = (Link)this.list.pop();
                if (this.preemptCount != 0) {
                    --this.preemptCount;
                }
                if (object == null) {
                    this.list.wait();
                    continue;
                }
                runnable = ((Link)object).runnable;
            }
            try {
                runnable.run();
            }
            catch (ThreadDeath object22) {
                throw object22;
            }
            catch (Throwable threadDeath) {
                threadDeath.printStackTrace();
            }
            ((Link)object).unlock();
            this.runnableInvoked(runnable);
        }
        Object var7_7 = null;
        RunnableQueue runnableQueue = this;
        synchronized (runnableQueue) {
            this.runnableQueueThread = null;
            return;
        }
    }

    public Thread getThread() {
        return this.runnableQueueThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runnable) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(new Link(runnable));
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Runnable runnable) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink lockableLink = new LockableLink(runnable);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.push(lockableLink);
            this.list.notify();
        }
        lockableLink.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptLater(Runnable runnable) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.add(this.preemptCount, new Link(runnable));
            ++this.preemptCount;
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preemptAndWait(Runnable runnable) throws InterruptedException {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        if (this.runnableQueueThread == Thread.currentThread()) {
            throw new IllegalStateException("Cannot be called from the RunnableQueue thread");
        }
        LockableLink lockableLink = new LockableLink(runnable);
        DoublyLinkedList doublyLinkedList = this.list;
        synchronized (doublyLinkedList) {
            this.list.add(this.preemptCount, lockableLink);
            ++this.preemptCount;
            this.list.notify();
        }
        lockableLink.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunnableQueueState getQueueState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendExecution(boolean bl) {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == SUSPENDED) {
                return;
            }
            if (this.state == RUNNING) {
                this.state = SUSPENDING;
                DoublyLinkedList doublyLinkedList = this.list;
                synchronized (doublyLinkedList) {
                    this.list.notify();
                }
            }
            if (bl) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeExecution() {
        if (this.runnableQueueThread == null) {
            throw new IllegalStateException("RunnableQueue not started or has exited");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != RUNNING) {
                this.state = RUNNING;
                this.stateLock.notifyAll();
            }
        }
    }

    public Object getIteratorLock() {
        return this.list;
    }

    public Iterator iterator() {
        return new Iterator(){
            Link head;
            Link link;
            {
                this.head = (Link)RunnableQueue.this.list.getHead();
            }

            public boolean hasNext() {
                if (this.head == null) {
                    return false;
                }
                if (this.link == null) {
                    return true;
                }
                return this.link != this.head;
            }

            public Object next() {
                if (this.head == null || this.head == this.link) {
                    throw new NoSuchElementException();
                }
                if (this.link == null) {
                    this.link = (Link)this.head.getNext();
                    return this.head.runnable;
                }
                Runnable runnable = this.link.runnable;
                this.link = (Link)this.link.getNext();
                return runnable;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public synchronized void setRunHandler(RunHandler runHandler) {
        this.runHandler = runHandler;
    }

    public synchronized RunHandler getRunHandler() {
        return this.runHandler;
    }

    protected synchronized void executionSuspended() {
        if (this.runHandler != null) {
            this.runHandler.executionSuspended(this);
        }
    }

    protected synchronized void executionResumed() {
        if (this.runHandler != null) {
            this.runHandler.executionResumed(this);
        }
    }

    protected synchronized void runnableInvoked(Runnable runnable) {
        if (this.runHandler != null) {
            this.runHandler.runnableInvoked(this, runnable);
        }
    }

    protected static class LockableLink
    extends Link {
        protected boolean locked;

        public LockableLink(Runnable runnable) {
            super(runnable);
        }

        public boolean isLocked() {
            return this.locked;
        }

        public synchronized void lock() throws InterruptedException {
            this.locked = true;
            this.notify();
            this.wait();
        }

        public synchronized void unlock() throws InterruptedException {
            while (!this.locked) {
                this.wait();
            }
            this.notify();
        }
    }

    protected static class Link
    extends DoublyLinkedList.Node {
        public Runnable runnable;

        public Link(Runnable runnable) {
            this.runnable = runnable;
        }

        public void unlock() throws InterruptedException {
        }
    }

    public static interface RunHandler {
        public void runnableInvoked(RunnableQueue var1, Runnable var2);

        public void executionSuspended(RunnableQueue var1);

        public void executionResumed(RunnableQueue var1);
    }

    public static class RunnableQueueState {
        final String value;

        private RunnableQueueState(String string) {
            this.value = string.intern();
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "[RunnableQueueState: " + this.value + "]";
        }
    }
}

