/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;

public class CompositeGraphicsNode
extends AbstractGraphicsNode
implements List {
    public static final Rectangle2D VIEWPORT = new Rectangle(0, 0, 0, 0);
    protected GraphicsNode[] children;
    protected int count;
    protected int modCount;
    protected Rectangle2D backgroundEnableRgn = null;
    private Rectangle2D geometryBounds;
    private Rectangle2D primitiveBounds;
    private Rectangle2D sensitiveBounds;
    private Shape outline;

    public List getChildren() {
        return this;
    }

    public void setBackgroundEnable(Rectangle2D rectangle2D) {
        this.backgroundEnableRgn = rectangle2D;
    }

    public Rectangle2D getBackgroundEnable() {
        return this.backgroundEnableRgn;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public void primitivePaint(Graphics2D graphics2D) {
        if (this.count == 0) {
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            GraphicsNode graphicsNode = this.children[i];
            if (graphicsNode == null) continue;
            graphicsNode.paint(graphics2D);
        }
    }

    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.geometryBounds = null;
        this.primitiveBounds = null;
        this.sensitiveBounds = null;
        this.outline = null;
    }

    public Rectangle2D getPrimitiveBounds() {
        if (this.primitiveBounds == null) {
            int n = 0;
            Rectangle2D rectangle2D = null;
            while (rectangle2D == null && n < this.count) {
                rectangle2D = this.children[n++].getTransformedBounds(GraphicsNode.IDENTITY);
            }
            if (rectangle2D == null) {
                return null;
            }
            this.primitiveBounds = rectangle2D;
            Rectangle2D rectangle2D2 = null;
            while (n < this.count) {
                if ((rectangle2D2 = this.children[n++].getTransformedBounds(GraphicsNode.IDENTITY)) == null) continue;
                if (this.primitiveBounds == null) {
                    return null;
                }
                this.primitiveBounds.add(rectangle2D2);
            }
            if (Thread.currentThread().isInterrupted()) {
                this.invalidateGeometryCache();
            }
        }
        return this.primitiveBounds;
    }

    public Rectangle2D getTransformedPrimitiveBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        int n = 0;
        Rectangle2D rectangle2D = null;
        while (rectangle2D == null && n < this.count) {
            rectangle2D = this.children[n++].getTransformedBounds(affineTransform2);
        }
        Rectangle2D rectangle2D2 = null;
        while (n < this.count) {
            if ((rectangle2D2 = this.children[n++].getTransformedBounds(affineTransform2)) == null) continue;
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    public Rectangle2D getGeometryBounds() {
        if (this.geometryBounds == null) {
            int n = 0;
            while (this.geometryBounds == null && n < this.count) {
                this.geometryBounds = this.children[n++].getTransformedGeometryBounds(GraphicsNode.IDENTITY);
            }
            Rectangle2D rectangle2D = null;
            while (n < this.count) {
                if ((rectangle2D = this.children[n++].getTransformedGeometryBounds(GraphicsNode.IDENTITY)) == null) continue;
                if (this.geometryBounds == null) {
                    return this.getGeometryBounds();
                }
                this.geometryBounds.add(rectangle2D);
            }
        }
        return this.geometryBounds;
    }

    public Rectangle2D getTransformedGeometryBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        Rectangle2D rectangle2D = null;
        int n = 0;
        while (rectangle2D == null && n < this.count) {
            rectangle2D = this.children[n++].getTransformedGeometryBounds(affineTransform2);
        }
        Rectangle2D rectangle2D2 = null;
        while (n < this.count) {
            if ((rectangle2D2 = this.children[n++].getTransformedGeometryBounds(affineTransform2)) == null) continue;
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    public Rectangle2D getSensitiveBounds() {
        if (this.sensitiveBounds != null) {
            return this.sensitiveBounds;
        }
        int n = 0;
        while (this.sensitiveBounds == null && n < this.count) {
            this.sensitiveBounds = this.children[n++].getTransformedSensitiveBounds(GraphicsNode.IDENTITY);
        }
        Rectangle2D rectangle2D = null;
        while (n < this.count) {
            if ((rectangle2D = this.children[n++].getTransformedSensitiveBounds(GraphicsNode.IDENTITY)) == null) continue;
            if (this.sensitiveBounds == null) {
                return this.getSensitiveBounds();
            }
            this.sensitiveBounds.add(rectangle2D);
        }
        return this.sensitiveBounds;
    }

    public Rectangle2D getTransformedSensitiveBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        Rectangle2D rectangle2D = null;
        int n = 0;
        while (rectangle2D == null && n < this.count) {
            rectangle2D = this.children[n++].getTransformedSensitiveBounds(affineTransform2);
        }
        Rectangle2D rectangle2D2 = null;
        while (n < this.count) {
            if ((rectangle2D2 = this.children[n++].getTransformedSensitiveBounds(affineTransform2)) == null) continue;
            rectangle2D.add(rectangle2D2);
        }
        return rectangle2D;
    }

    public boolean contains(Point2D point2D) {
        Rectangle2D rectangle2D = this.getSensitiveBounds();
        if (this.count > 0 && rectangle2D != null && rectangle2D.contains(point2D)) {
            Point2D point2D2 = null;
            Point2D point2D3 = null;
            for (int i = 0; i < this.count; ++i) {
                AffineTransform affineTransform = this.children[i].getInverseTransform();
                point2D3 = affineTransform != null ? (point2D2 = affineTransform.transform(point2D, point2D2)) : point2D;
                if (!this.children[i].contains(point2D3)) continue;
                return true;
            }
        }
        return false;
    }

    public GraphicsNode nodeHitAt(Point2D point2D) {
        Rectangle2D rectangle2D = this.getSensitiveBounds();
        if (this.count > 0 && rectangle2D != null && rectangle2D.contains(point2D)) {
            Point2D point2D2 = null;
            Point2D point2D3 = null;
            for (int i = this.count - 1; i >= 0; --i) {
                AffineTransform affineTransform = this.children[i].getInverseTransform();
                point2D3 = affineTransform != null ? (point2D2 = affineTransform.transform(point2D, point2D2)) : point2D;
                GraphicsNode graphicsNode = this.children[i].nodeHitAt(point2D3);
                if (graphicsNode == null) continue;
                return graphicsNode;
            }
        }
        return null;
    }

    public Shape getOutline() {
        if (this.outline == null) {
            this.outline = new GeneralPath();
            for (int i = 0; i < this.count; ++i) {
                Shape shape = this.children[i].getOutline();
                if (shape == null) continue;
                AffineTransform affineTransform = this.children[i].getTransform();
                if (affineTransform != null) {
                    ((GeneralPath)this.outline).append(affineTransform.createTransformedShape(shape), false);
                    continue;
                }
                ((GeneralPath)this.outline).append(shape, false);
            }
        }
        return this.outline;
    }

    protected void setRoot(RootGraphicsNode rootGraphicsNode) {
        super.setRoot(rootGraphicsNode);
        for (int i = 0; i < this.count; ++i) {
            GraphicsNode graphicsNode = this.children[i];
            ((AbstractGraphicsNode)graphicsNode).setRoot(rootGraphicsNode);
        }
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    public Iterator iterator() {
        return new Itr();
    }

    public Object[] toArray() {
        Object[] objectArray = new GraphicsNode[this.count];
        for (int i = 0; i < this.count; ++i) {
            objectArray[i] = this.children[i];
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.count) {
            objectArray = new GraphicsNode[this.count];
        }
        System.arraycopy(this.children, 0, objectArray, 0, this.count);
        if (objectArray.length > this.count) {
            objectArray[this.count] = null;
        }
        return objectArray;
    }

    public Object get(int n) {
        this.checkRange(n);
        return this.children[n];
    }

    public Object set(int n, Object object) {
        if (!(object instanceof GraphicsNode)) {
            throw new IllegalArgumentException(object + " is not a GraphicsNode");
        }
        this.checkRange(n);
        GraphicsNode graphicsNode = (GraphicsNode)object;
        this.fireGraphicsNodeChangeStarted(graphicsNode);
        if (graphicsNode.getParent() != null) {
            graphicsNode.getParent().getChildren().remove(graphicsNode);
        }
        GraphicsNode graphicsNode2 = this.children[n];
        this.children[n] = graphicsNode;
        ((AbstractGraphicsNode)graphicsNode).setParent(this);
        ((AbstractGraphicsNode)graphicsNode2).setParent(null);
        ((AbstractGraphicsNode)graphicsNode).setRoot(this.getRoot());
        ((AbstractGraphicsNode)graphicsNode2).setRoot(null);
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return graphicsNode2;
    }

    public boolean add(Object object) {
        if (!(object instanceof GraphicsNode)) {
            throw new IllegalArgumentException(object + " is not a GraphicsNode");
        }
        GraphicsNode graphicsNode = (GraphicsNode)object;
        this.fireGraphicsNodeChangeStarted(graphicsNode);
        if (graphicsNode.getParent() != null) {
            graphicsNode.getParent().getChildren().remove(graphicsNode);
        }
        this.ensureCapacity(this.count + 1);
        this.children[this.count++] = graphicsNode;
        ((AbstractGraphicsNode)graphicsNode).setParent(this);
        ((AbstractGraphicsNode)graphicsNode).setRoot(this.getRoot());
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return true;
    }

    public void add(int n, Object object) {
        if (!(object instanceof GraphicsNode)) {
            throw new IllegalArgumentException(object + " is not a GraphicsNode");
        }
        if (n > this.count || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.count);
        }
        GraphicsNode graphicsNode = (GraphicsNode)object;
        this.fireGraphicsNodeChangeStarted(graphicsNode);
        if (graphicsNode.getParent() != null) {
            graphicsNode.getParent().getChildren().remove(graphicsNode);
        }
        this.ensureCapacity(this.count + 1);
        System.arraycopy(this.children, n, this.children, n + 1, this.count - n);
        this.children[n] = graphicsNode;
        ++this.count;
        ((AbstractGraphicsNode)graphicsNode).setParent(this);
        ((AbstractGraphicsNode)graphicsNode).setRoot(this.getRoot());
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object object) {
        if (!(object instanceof GraphicsNode)) {
            throw new IllegalArgumentException(object + " is not a GraphicsNode");
        }
        GraphicsNode graphicsNode = (GraphicsNode)object;
        if (graphicsNode.getParent() != this) {
            return false;
        }
        int n = 0;
        while (graphicsNode != this.children[n]) {
            ++n;
        }
        this.remove(n);
        return true;
    }

    public Object remove(int n) {
        this.checkRange(n);
        GraphicsNode graphicsNode = this.children[n];
        this.fireGraphicsNodeChangeStarted(graphicsNode);
        ++this.modCount;
        int n2 = this.count - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.children, n + 1, this.children, n, n2);
        }
        this.children[--this.count] = null;
        if (this.count == 0) {
            this.children = null;
        }
        ((AbstractGraphicsNode)graphicsNode).setParent(null);
        ((AbstractGraphicsNode)graphicsNode).setRoot(null);
        this.invalidateGeometryCache();
        this.fireGraphicsNodeChangeCompleted();
        return graphicsNode;
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object object) {
        if (object == null || !(object instanceof GraphicsNode)) {
            return -1;
        }
        if (((GraphicsNode)object).getParent() == this) {
            for (int i = 0; i < this.count; ++i) {
                if (object != this.children[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        if (object == null || !(object instanceof GraphicsNode)) {
            return -1;
        }
        if (((GraphicsNode)object).getParent() == this) {
            for (int i = this.count - 1; i >= 0; --i) {
                if (object != this.children[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        if (n < 0 || n > this.count) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new ListItr(n);
    }

    public List subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    private void checkRange(int n) {
        if (n >= this.count || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.count);
        }
    }

    public void ensureCapacity(int n) {
        if (this.children == null) {
            this.children = new GraphicsNode[4];
        }
        ++this.modCount;
        int n2 = this.children.length;
        if (n > n2) {
            GraphicsNode[] graphicsNodeArray = this.children;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.children = new GraphicsNode[n3];
            System.arraycopy(graphicsNodeArray, 0, this.children, 0, this.count);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int n) {
            this.cursor = n;
        }

        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        public Object previous() {
            try {
                Object object = CompositeGraphicsNode.this.get(--this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void set(Object object) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.set(this.lastRet, object);
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object object) {
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.add(this.cursor++, object);
                this.lastRet = -1;
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = CompositeGraphicsNode.this.modCount;
        }

        public boolean hasNext() {
            return this.cursor != CompositeGraphicsNode.this.count;
        }

        public Object next() {
            try {
                Object object = CompositeGraphicsNode.this.get(this.cursor);
                this.checkForComodification();
                this.lastRet = this.cursor++;
                return object;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                CompositeGraphicsNode.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = CompositeGraphicsNode.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (CompositeGraphicsNode.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

