/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.SourceDescriptor;
import org.apache.cocoon.components.source.SourceInspector;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;

public final class SourceDescriptorManager
extends AbstractLogEnabled
implements SourceDescriptor,
Contextualizable,
Serviceable,
Configurable,
Initializable,
Disposable,
ThreadSafe {
    private Set m_inspectors;
    private Context m_context;
    private ServiceManager m_manager;
    private Configuration m_configuration;

    public void contextualize(Context context) throws ContextException {
        this.m_context = context;
    }

    public void service(ServiceManager manager) {
        this.m_manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_configuration = configuration;
    }

    public void initialize() throws Exception {
        this.m_inspectors = new HashSet();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        Configuration[] children = this.m_configuration.getChildren();
        int i = 0;
        while (i < children.length) {
            SourceInspector inspector;
            String className = children[i].getAttribute("class", "");
            try {
                Class<?> inspectorClass = classloader.loadClass(className);
                inspector = (SourceInspector)inspectorClass.newInstance();
            }
            catch (InstantiationException ie) {
                throw new ConfigurationException("Could not instantiate class " + className, (Throwable)ie);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException("Could not load class " + className, (Throwable)cnfe);
            }
            catch (IllegalAccessException iae) {
                throw new ConfigurationException("Could not load class " + className, (Throwable)iae);
            }
            ContainerUtil.enableLogging((Object)inspector, (Logger)this.getLogger());
            ContainerUtil.contextualize((Object)inspector, (Context)this.m_context);
            ContainerUtil.service((Object)inspector, (ServiceManager)this.m_manager);
            ContainerUtil.configure((Object)inspector, (Configuration)children[i]);
            ContainerUtil.parameterize((Object)inspector, (Parameters)Parameters.fromConfiguration((Configuration)children[i]));
            ContainerUtil.initialize((Object)inspector);
            this.m_inspectors.add(inspector);
            ++i;
        }
        this.m_configuration = null;
        this.m_context = null;
        this.m_manager = null;
    }

    public void dispose() {
        Iterator iter = this.m_inspectors.iterator();
        while (iter.hasNext()) {
            ContainerUtil.dispose(iter.next());
        }
        this.m_inspectors = null;
    }

    public SourceProperty getSourceProperty(Source source, String namespace, String name) throws SourceException {
        Iterator inspectors = this.m_inspectors.iterator();
        while (inspectors.hasNext()) {
            SourceInspector inspector = (SourceInspector)inspectors.next();
            SourceProperty property = inspector.getSourceProperty(source, namespace, name);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public SourceProperty[] getSourceProperties(Source source) throws SourceException {
        HashSet<SourceProperty> result = new HashSet<SourceProperty>();
        Iterator inspectors = this.m_inspectors.iterator();
        while (inspectors.hasNext()) {
            SourceInspector inspector = (SourceInspector)inspectors.next();
            SourceProperty[] properties = inspector.getSourceProperties(source);
            if (properties == null) continue;
            result.addAll(Arrays.asList(properties));
        }
        return result.toArray(new SourceProperty[result.size()]);
    }

    public boolean handlesProperty(String namespace, String name) {
        Iterator inspectors = this.m_inspectors.iterator();
        while (inspectors.hasNext()) {
            SourceInspector inspector = (SourceInspector)inspectors.next();
            if (!inspector.handlesProperty(namespace, name)) continue;
            return true;
        }
        return false;
    }

    public void removeSourceProperty(Source source, String ns, String name) throws SourceException {
        Iterator inspectors = this.m_inspectors.iterator();
        while (inspectors.hasNext()) {
            SourceInspector inspector = (SourceInspector)inspectors.next();
            if (!(inspector instanceof SourceDescriptor)) continue;
            ((SourceDescriptor)inspector).removeSourceProperty(source, ns, name);
        }
    }

    public void setSourceProperty(Source source, SourceProperty property) throws SourceException {
        Iterator inspectors = this.m_inspectors.iterator();
        while (inspectors.hasNext()) {
            SourceInspector inspector = (SourceInspector)inspectors.next();
            if (!(inspector instanceof SourceDescriptor)) continue;
            ((SourceDescriptor)inspector).setSourceProperty(source, property);
        }
    }

    public SourceValidity getValidity(Source source) {
        AggregatedValidity validity = new AggregatedValidity();
        Iterator inspectors = this.m_inspectors.iterator();
        while (inspectors.hasNext()) {
            SourceInspector inspector = (SourceInspector)inspectors.next();
            SourceValidity sv = inspector.getValidity(source);
            if (sv == null) {
                return null;
            }
            validity.add(sv);
        }
        return validity;
    }
}

