/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentException;
import org.apache.excalibur.instrument.manager.http.AbstractHTMLHandler;
import org.apache.excalibur.instrument.manager.http.InstrumentManagerHTTPConnector;
import org.apache.excalibur.instrument.manager.http.server.HTTPRedirect;

public class HTMLInstrumentHandler
extends AbstractHTMLHandler {
    private InstrumentManagerHTTPConnector m_connector;

    public HTMLInstrumentHandler(DefaultInstrumentManager manager, InstrumentManagerHTTPConnector connector) {
        super("/instrument.html", manager);
        this.m_connector = connector;
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        String type;
        InstrumentDescriptor desc;
        String name = this.getParameter(parameters, "name");
        try {
            desc = this.getInstrumentManager().locateInstrumentDescriptor(name);
        }
        catch (NoSuchInstrumentException e) {
            int pos = name.lastIndexOf(46);
            if (pos >= 0) {
                throw new HTTPRedirect("instrumentable.html?name=" + this.urlEncode(name.substring(0, pos)));
            }
            throw new HTTPRedirect("instrument-manager.html");
        }
        StringBuffer types = new StringBuffer();
        types.append("<select name='type' onKeyPress=\"javascript:fieldChanged()\">");
        StringBuffer presets = new StringBuffer();
        presets.append("<select name='preset' onChange=\"javascript:applyPreset(this.options[this.selectedIndex].value)\">");
        presets.append("<option value='0-0' selected>-- Select a Preset --</option>");
        switch (desc.getType()) {
            case 1: {
                type = "Counter";
                types.append("<option value='101' selected>Count</option>");
                presets.append("<option value='101-0'>Count / Second Over 10 Minutes</option>");
                presets.append("<option value='101-1'>Count / Minute Over 1 Day</option>");
                presets.append("<option value='101-2'>Count / Hour Over 1 Month</option>");
                break;
            }
            case 2: {
                type = "Value";
                types.append("<option value='103' selected>Maximum Value</option>");
                types.append("<option value='102'>Minimum Value</option>");
                types.append("<option value='104'>Mean Value</option>");
                presets.append("<option value='103-0'>Max Value / Second Over 10 Minutes</option>");
                presets.append("<option value='103-1'>Max Value / Minute Over 1 Day</option>");
                presets.append("<option value='103-2'>Max Value / Hour Over 1 Month</option>");
                presets.append("<option value='102-0'>Min Value / Second Over 10 Minutes</option>");
                presets.append("<option value='102-1'>Min Value / Minute Over 1 Day</option>");
                presets.append("<option value='102-2'>Min Value / Hour Over 1 Month</option>");
                presets.append("<option value='104-0'>Mean Value / Second Over 10 Minutes</option>");
                presets.append("<option value='104-1'>Mean Value / Minute Over 1 Day</option>");
                presets.append("<option value='104-2'>Mean Value / Hour Over 1 Month</option>");
                break;
            }
            default: {
                type = "Unknown";
            }
        }
        types.append("</select>");
        presets.append("</select>");
        out.println("<html>");
        out.println("<head><title>" + desc.getDescription() + "</title></head>");
        out.println("<body>");
        this.breadCrumbs(out, desc, false);
        out.println("<h2>Instrument</h2>");
        this.startTable(out);
        this.tableRow(out, 0, "Name", desc.getName());
        this.tableRow(out, 0, "Description", desc.getDescription());
        this.tableRow(out, 0, "Type", type);
        this.endTable(out);
        InstrumentSampleDescriptor[] samples = desc.getInstrumentSampleDescriptors();
        if (samples.length > 0) {
            out.println("<h2>Registered Samples</h2>");
            this.outputInstrumentSamples(out, samples, this.m_connector.isReadOnly());
        }
        if (!this.m_connector.isReadOnly()) {
            out.println("<h2>Register Sample</h2>");
            out.println("<SCRIPT LANGUAGE=\"JavaScript\">");
            out.println("function fieldChanged() {");
            out.println("  var form = document.forms[0];");
            out.println("  form.preset.value=\"0-0\";");
            out.println("}");
            out.println("function applyPreset(preset) {");
            out.println("  var form = document.forms[0];");
            out.println("  var pos = preset.indexOf('-');");
            out.println("  var type = preset.substring(0, pos);");
            out.println("  var spec = preset.substring(pos + 1);");
            out.println("  var prefix;");
            out.println("  if (type == 0) {");
            out.println("    return;");
            out.println("  } else if (type == 101) {");
            out.println("    typeLbl = \"Count\"");
            out.println("  } else if (type == 103) {");
            out.println("    typeLbl = \"Max Value\"");
            out.println("  } else if (type == 102) {");
            out.println("    typeLbl = \"Min Value\"");
            out.println("  } else if (type == 104) {");
            out.println("    typeLbl = \"Mean Value\"");
            out.println("  } else {");
            out.println("    typeLbl = \"Unknown\"");
            out.println("  }");
            out.println("  var intervalLbl;");
            out.println("  var interval;");
            out.println("  var size;");
            out.println("  var lease;");
            out.println("  if (spec == 1) {");
            out.println("    intervalLbl = \"Minute\";");
            out.println("    interval = 60000;");
            out.println("    size = 1440;");
            out.println("    lease = 86400000;");
            out.println("  } else if (spec == 2) {");
            out.println("    intervalLbl = \"Hour\";");
            out.println("    interval = 3600000;");
            out.println("    size = 672;");
            out.println("    lease = 86400000;");
            out.println("  } else {");
            out.println("    intervalLbl = \"Second\";");
            out.println("    interval = 1000;");
            out.println("    size = 600;");
            out.println("    lease = 600000;");
            out.println("  }");
            out.println("  form.description.value = typeLbl + \" / \" + intervalLbl;");
            out.println("  form.interval.value = interval;");
            out.println("  form.size.value = size;");
            out.println("  form.lease.value = lease;");
            out.println("  form.type.value = type;");
            out.println("}");
            out.println("</SCRIPT>");
            out.println("<form action='create-sample.html' method='GET' accept-charset='UTF-8'>");
            this.startTable(out);
            this.tableRow(out, 0, "Description", "<input name='description' type='text' size='40' value='' onKeyPress=\"javascript:fieldChanged()\">");
            this.tableRow(out, 0, "Interval (ms.)", "<input name='interval' type='text' size='10' value='' onKeyPress=\"javascript:fieldChanged()\">");
            this.tableRow(out, 0, "Size", "<input name='size' type='text' size='10' value='' onKeyPress=\"javascript:fieldChanged()\">");
            this.tableRow(out, 0, "Lease (ms.)", "<input name='lease' type='text' size='10' value='' onKeyPress=\"javascript:fieldChanged()\">");
            this.tableRow(out, 0, "Type", types.toString());
            this.tableRow(out, 0, "Presets", presets.toString());
            this.endTable(out);
            out.println("<input type='hidden' name='name' value='" + desc.getName() + "'>");
            out.println("<input type='submit' value='Submit'>");
            out.println("</form>");
        }
        this.footer(out);
        out.println("</body>");
        out.println("</html>");
    }
}

