/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.mail.MailSender;
import org.apache.cocoon.mail.datasource.AbstractDataSource;
import org.apache.cocoon.mail.datasource.FilePartDataSource;
import org.apache.cocoon.mail.datasource.InputStreamDataSource;
import org.apache.cocoon.mail.datasource.SourceDataSource;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class MailMessageSender
extends AbstractLogEnabled
implements MailSender,
Configurable,
Serviceable,
Initializable,
Component {
    private ServiceManager manager;
    private Session session;
    private String smtpHost;
    private String smtpUser;
    private String smtpPswd;
    private String from;
    private String to;
    private String replyTo;
    private String cc;
    private String bcc;
    private String subject;
    private Attachment body;
    private String bodyType;
    private String bodySrcType;
    private List attachments;
    private Exception exception;

    private Logger getMyLogger() {
        return this.getLogger();
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }

    public MailMessageSender() {
    }

    public MailMessageSender(String smtpHost) {
        smtpHost = smtpHost.trim();
        this.setSmtpHost(smtpHost);
        this.initialize();
    }

    public void service(ServiceManager manager) {
        this.manager = manager;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.smtpHost = config.getChild("smtp-host").getValue(null);
        this.smtpUser = config.getChild("smtp-user").getValue(null);
        this.smtpPswd = config.getChild("smtp-password").getValue(null);
    }

    public void initialize() {
        this.initSession();
        this.attachments = new ArrayList();
    }

    private void initSession() {
        Properties properties = new Properties();
        if (this.smtpHost == null || this.smtpHost.length() == 0 || this.smtpHost.equals("null")) {
            properties.put("mail.smtp.host", "127.0.0.1");
        } else {
            properties.put("mail.smtp.host", this.smtpHost);
        }
        if (this.smtpUser == null || this.smtpUser.length() == 0 || this.smtpUser.equals("null")) {
            this.session = Session.getInstance((Properties)properties);
        } else {
            properties.put("mail.smtp.auth", "true");
            this.session = Session.getInstance((Properties)properties, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailMessageSender.this.smtpUser, MailMessageSender.this.smtpPswd);
                }
            });
        }
    }

    public void setSmtpHost(String hostname) {
        this.smtpHost = hostname;
        this.initSession();
    }

    public void setSmtpHost(String hostname, String username, String password) {
        this.smtpUser = username;
        this.smtpPswd = password;
        this.setSmtpHost(hostname);
    }

    public void send() throws AddressException, MessagingException {
        SourceResolver resolver = null;
        try {
            resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
            this.doSend(resolver);
        }
        catch (ServiceException se) {
            throw new CascadingRuntimeException("Cannot get Source Resolver to send mail", (Throwable)se);
        }
        finally {
            this.manager.release((Object)resolver);
        }
    }

    public void send(org.apache.cocoon.environment.SourceResolver resolver) throws AddressException, MessagingException {
        this.doSend((SourceResolver)resolver);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doSend(SourceResolver resolver) throws AddressException, MessagingException {
        Iterator j2222;
        MimeMessage message = new MimeMessage(this.session);
        if (this.from == null) {
            throw new AddressException("No from address");
        }
        try {
            message.setFrom((Address)new InternetAddress(this.from));
        }
        catch (AddressException e) {
            throw new AddressException("Invalid from address: " + this.from + ": " + e.getMessage());
        }
        if (this.to == null) {
            throw new AddressException("no to address");
        }
        try {
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.to));
        }
        catch (AddressException e) {
            throw new AddressException("Invalid to address: " + this.to + ": " + e.getMessage());
        }
        if (this.replyTo != null) {
            try {
                message.setReplyTo((Address[])InternetAddress.parse((String)this.replyTo));
            }
            catch (AddressException e) {
                throw new AddressException("Invalid replyTo address: " + this.replyTo + ": " + e.getMessage());
            }
        }
        if (this.cc != null) {
            try {
                message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.cc));
            }
            catch (AddressException e) {
                throw new AddressException("Invalid cc address: " + this.cc + ": " + e.getMessage());
            }
        }
        if (this.bcc != null) {
            try {
                message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.bcc));
            }
            catch (AddressException e) {
                throw new AddressException("Invalid bcc address: " + this.bcc + ": " + e.getMessage());
            }
        }
        if (this.subject != null) {
            message.setSubject(this.subject);
        }
        message.setSentDate(new Date());
        Attachment a = null;
        ArrayList sources = new ArrayList();
        try {
            try {
                if (this.attachments.isEmpty()) {
                    if (this.body != null) {
                        a = this.body;
                        a.setContentTo(resolver, sources, (MimePart)message);
                    }
                } else {
                    MimeMultipart multipart = new MimeMultipart();
                    message.setContent((Multipart)multipart);
                    if (this.body != null) {
                        a = this.body;
                        multipart.addBodyPart((BodyPart)a.getBodyPart(resolver, sources));
                    }
                    Iterator i = this.attachments.iterator();
                    while (i.hasNext()) {
                        a = (Attachment)i.next();
                        multipart.addBodyPart((BodyPart)a.getBodyPart(resolver, sources));
                    }
                }
                message.saveChanges();
                Transport.send((Message)message);
            }
            catch (MalformedURLException e) {
                throw new MessagingException("Malformed attachment URL: " + a.getObject() + " error " + e.getMessage());
            }
            catch (IOException e) {
                throw new MessagingException("IOException accessing attachment URL: " + a.getObject() + " error " + e.getMessage());
            }
            Object var8_14 = null;
            j2222 = sources.iterator();
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            Iterator j2222 = sources.iterator();
            while (true) {
                if (!j2222.hasNext()) {
                    throw throwable;
                }
                resolver.release((Source)j2222.next());
            }
        }
        while (j2222.hasNext()) {
            resolver.release((Source)j2222.next());
        }
        return;
    }

    public boolean sendIt() {
        this.exception = null;
        try {
            this.send();
        }
        catch (Exception e) {
            this.exception = e;
        }
        return this.exception == null;
    }

    public boolean sendIt(org.apache.cocoon.environment.SourceResolver resolver) {
        this.exception = null;
        try {
            this.send(resolver);
        }
        catch (Exception e) {
            this.exception = e;
        }
        return this.exception == null;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setFrom(String from) {
        if (!this.isNullOrEmpty(from)) {
            this.from = from.trim();
        }
    }

    public void setTo(String to) {
        if (!this.isNullOrEmpty(to)) {
            this.to = to.trim();
        }
    }

    public void setReplyTo(String replyTo) {
        if (!this.isNullOrEmpty(replyTo)) {
            this.replyTo = replyTo.trim();
        }
    }

    public void setCc(String cc) {
        if (!this.isNullOrEmpty(cc)) {
            this.cc = cc.trim();
        }
    }

    public void setBcc(String bcc) {
        if (!this.isNullOrEmpty(bcc)) {
            this.bcc = bcc.trim();
        }
    }

    public void setSubject(String subject) {
        if (!this.isNullOrEmpty(subject)) {
            this.subject = subject;
        }
    }

    public void setCharset(String charset) {
        if (!this.isNullOrEmpty(charset)) {
            this.bodyType = "text/plain; charset=" + charset.trim();
            if (this.body != null && this.body.isText() && this.body.type == null) {
                this.body.type = this.bodyType;
            }
        }
    }

    public void setBody(String body) {
        if (!this.isNullOrEmpty(body)) {
            this.setBody(body, this.bodyType);
        }
    }

    public void setBodyFromSrc(String src) {
        if (!this.isNullOrEmpty(src)) {
            this.setBodyURL(src, this.bodySrcType);
        }
    }

    public void setBodyFromSrcMimeType(String srcMimeType) {
        if (!this.isNullOrEmpty(srcMimeType)) {
            this.bodySrcType = srcMimeType;
            if (this.body != null && this.body.isURL() && this.body.type == null) {
                this.body.type = srcMimeType;
            }
        }
    }

    public void setBody(Object body) {
        this.setBody(body, null);
    }

    public void setBody(Object body, String type) {
        if (body != null) {
            this.body = new Body(body, type);
        }
    }

    public void setBodyURL(String url) {
        this.setBodyURL(url, null);
    }

    public void setBodyURL(String url, String type) {
        if (this.body != null) {
            this.body = new Body((Object)url, type, true);
        }
    }

    public void addAttachment(Object attachment) {
        if (attachment != null) {
            this.attachments.add(new Attachment(attachment));
        }
    }

    public void addAttachment(Object attachment, String type, String name) {
        if (attachment != null) {
            this.attachments.add(new Attachment(attachment, type, name));
        }
    }

    public void addAttachmentURL(String url) {
        if (url != null) {
            this.attachments.add(new Attachment(url, null, null, true));
        }
    }

    public void addAttachmentURL(String url, String type, String name) {
        if (url != null) {
            this.attachments.add(new Attachment(url, type, name, true));
        }
    }

    private class Body
    extends Attachment {
        public Body(Object obj) {
            super(obj);
        }

        public Body(Object obj, String type) {
            super(obj, type, null);
        }

        public Body(Object obj, String type, boolean isURI) {
            super(obj, type, null, isURI);
        }

        public DataSource getDataSource(SourceResolver resolver, List sources) throws IOException, MessagingException {
            AbstractDataSource ds = (AbstractDataSource)super.getDataSource(resolver, sources);
            ds.setName(null);
            return ds;
        }
    }

    private class Attachment {
        private Object obj;
        private String type;
        private String name;
        protected boolean isURL;

        public Attachment(Object obj) {
            this(obj, null, null);
        }

        public Attachment(Object obj, String type, String name) {
            this(obj, type, name, false);
        }

        public Attachment(Object obj, String type, String name, boolean isURI) {
            this.obj = obj;
            this.type = type;
            this.name = name;
            this.isURL = isURI;
            if (MailMessageSender.this.isNullOrEmpty(this.type)) {
                this.type = null;
            }
            if (MailMessageSender.this.isNullOrEmpty(this.name)) {
                this.name = null;
            }
        }

        public boolean isURL() {
            return this.isURL;
        }

        public boolean isText() {
            return !this.isURL() && this.obj instanceof String;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public Object getObject() {
            return this.obj;
        }

        public String getText() {
            return (String)this.obj;
        }

        public DataSource getDataSource(SourceResolver resolver, List sources) throws IOException, MessagingException {
            AbstractDataSource ds = null;
            if (this.isURL) {
                String url = (String)this.getObject();
                Source src = resolver.resolveURI(url);
                sources.add(src);
                if (src.exists()) {
                    ds = new SourceDataSource(src, this.getType(), this.getName());
                }
            } else if (this.getObject() instanceof Part) {
                Part part = (Part)this.getObject();
                ds = new FilePartDataSource(part, this.getType(), this.getName());
            } else if (this.getObject() instanceof InputStream) {
                InputStream in = (InputStream)this.getObject();
                ds = new InputStreamDataSource(in, this.getType(), this.getName());
            } else if (this.getObject() instanceof byte[]) {
                byte[] data = (byte[])this.getObject();
                ds = new InputStreamDataSource(data, this.getType(), this.getName());
            } else {
                throw new MessagingException("Not yet supported: " + this.getObject());
            }
            if (ds != null) {
                ds.enableLogging(MailMessageSender.this.getMyLogger());
            }
            return ds;
        }

        public void setContentTo(SourceResolver resolver, List sources, MimePart part) throws IOException, MessagingException {
            if (this.isText()) {
                if (this.type != null) {
                    part.setContent((Object)this.getText(), this.type);
                } else {
                    part.setText(this.getText());
                }
                if (this.name != null) {
                    part.setFileName(this.name);
                }
            } else {
                DataSource ds = this.getDataSource(resolver, sources);
                part.setDataHandler(new DataHandler(ds));
                String name = ds.getName();
                if (name != null) {
                    part.setFileName(name);
                }
            }
        }

        public MimeBodyPart getBodyPart(SourceResolver resolver, List sources) throws IOException, MessagingException {
            MimeBodyPart part = new MimeBodyPart();
            this.setContentTo(resolver, sources, (MimePart)part);
            return part;
        }
    }
}

