/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.transformation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.transformation.AbstractCopletTransformer;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.excalibur.source.SourceUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HTMLEventLinkTransformer
extends AbstractCopletTransformer {
    protected String attributeName;
    protected String jxPath;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.attributeName = par.getParameter("attribute-name", "application-uri");
        this.jxPath = "temporaryAttributes/" + this.attributeName;
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        boolean processed = false;
        if ("a".equals(name)) {
            boolean convert = false;
            boolean isRemoteAnchor = this.isRemoteAnchor(attr);
            if (isRemoteAnchor) {
                convert = this.isExternalLink(attr);
            }
            this.stack.push(convert ? Boolean.TRUE : Boolean.FALSE);
            if (convert) {
                this.createAnchorEvent(attr);
                processed = true;
            }
        } else if ("form".equals(name)) {
            this.createFormEvent(attr);
            processed = true;
        }
        if (!processed) {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        boolean processed = false;
        if ("a".equals(name)) {
            Boolean converted = (Boolean)this.stack.pop();
            if (converted.booleanValue()) {
                this.xmlConsumer.endElement("http://apache.org/cocoon/portal/coplet/1.0", "link", "coplet:link");
                this.xmlConsumer.endPrefixMapping("coplet");
                processed = true;
            }
        } else if ("form".equals(name)) {
            this.xmlConsumer.endElement("http://apache.org/cocoon/portal/coplet/1.0", "link", "coplet:link");
            this.xmlConsumer.endPrefixMapping("coplet");
            processed = true;
        }
        if (!processed) {
            super.endElement(uri, name, raw);
        }
    }

    protected void createAnchorEvent(Attributes attributes) throws SAXException {
        AttributesImpl newAttributes = new AttributesImpl(attributes);
        newAttributes.removeAttribute("href");
        newAttributes.removeAttribute("external");
        String link = attributes.getValue("href");
        CopletInstanceData cid = this.getCopletInstanceData();
        link = this.getLink((String)cid.getTemporaryAttribute(this.attributeName), link);
        newAttributes.addCDATAAttribute("path", this.jxPath);
        newAttributes.addCDATAAttribute("value", link);
        newAttributes.addCDATAAttribute("coplet", cid.getId());
        newAttributes.addCDATAAttribute("format", "html-link");
        this.xmlConsumer.startPrefixMapping("coplet", "http://apache.org/cocoon/portal/coplet/1.0");
        this.xmlConsumer.startElement("http://apache.org/cocoon/portal/coplet/1.0", "link", "coplet:link", (Attributes)newAttributes);
    }

    protected void createFormEvent(Attributes attributes) throws SAXException {
        AttributesImpl newAttributes = new AttributesImpl(attributes);
        newAttributes.removeAttribute("action");
        String link = attributes.getValue("action");
        CopletInstanceData cid = this.getCopletInstanceData();
        link = this.getLink((String)cid.getTemporaryAttribute(this.attributeName), link);
        newAttributes.addCDATAAttribute("path", this.jxPath);
        newAttributes.addCDATAAttribute("value", link);
        newAttributes.addCDATAAttribute("coplet", cid.getId());
        newAttributes.addCDATAAttribute("format", "html-form");
        if (newAttributes.getIndex("method") == -1) {
            newAttributes.addCDATAAttribute("method", "POST");
        }
        this.xmlConsumer.startPrefixMapping("coplet", "http://apache.org/cocoon/portal/coplet/1.0");
        this.xmlConsumer.startElement("http://apache.org/cocoon/portal/coplet/1.0", "link", "coplet:link", (Attributes)newAttributes);
    }

    protected String getLink(String base, String link) {
        String v = SourceUtil.absolutize((String)base, (String)link);
        return v;
    }

    protected boolean isRemoteAnchor(Attributes attributes) {
        String link = attributes.getValue("href");
        return link != null && link.trim().length() > 0 && !link.trim().startsWith("#");
    }

    private boolean isExternalLink(Attributes attributes) {
        String external = attributes.getValue("external");
        if (external != null && external.trim().length() > 0 && external.trim().toLowerCase().equals("true")) {
            return true;
        }
        String link = attributes.getValue("href");
        return link != null && link.startsWith("mailto:");
    }
}

