/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
 */
/*
 * Created by IntelliJ IDEA.
 * User: fglorieux
 * Date: 24 sept. 2002
 * Time: 21:25:14
 * To change template for new class use
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package fr.gouv.culture.sdx.sitemap;

import fr.gouv.culture.sdx.application.Application;
import fr.gouv.culture.sdx.user.UserInformation;
import fr.gouv.culture.sdx.utils.configuration.ConfigurationUtils;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ConfigurableServiceableAction;
import org.apache.cocoon.environment.*;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;


public class AdminAction extends ConfigurableServiceableAction
implements ThreadSafe {
	fr.gouv.culture.sdx.framework.FrameworkImpl sdx_frame;

	public Map act(Redirector redirector,
			SourceResolver resolver,
			Map objectModel,
			String source,
			Parameters params) throws ComponentException {
		
		
		Map sitemapParams = new HashMap();
		sitemapParams.put("admin", "true");

		try {
			ConfigurationUtils.checkServiceManager(this.manager);
			sdx_frame = (fr.gouv.culture.sdx.framework.FrameworkImpl) this.manager.lookup(fr.gouv.culture.sdx.framework.Framework.ROLE);
			if (sdx_frame == null) return null;
			UserInformation sdx_user;
			Request request = ObjectModelHelper.getRequest(objectModel);
			if (request == null) return null;
			Enumeration sdx_enum = new java.util.StringTokenizer(request.getServletPath(), "/");
			String sdx_string = ((java.util.StringTokenizer) sdx_enum).nextToken();
			if (sdx_string == null || "".equals(sdx_string) || "sdx".equals(sdx_string)) return null;
			Application sdx_application = sdx_frame.getApplicationByPath(sdx_string);
			if (sdx_application == null) return null;
			Session session = request.getSession(true);
			if (session == null) return null;
			sdx_user = (UserInformation) session.getAttribute("sdx_user");
			if (sdx_user == null) return null;
			if (sdx_user.isAdmin()) return sitemapParams;
		} catch (Exception e) {
			return null;
		} finally {
			if (sdx_frame != null) manager.release(sdx_frame);
		}
		return null;
	}
}

