/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.avalon.framework.logger.LogEnabled;

/**
 * A generic connection to a repository.
 *
 * Each type of repository is responsible for implementing some kind of connection,
 * even if this connection doesn't do anything. The interface is loosely based on
 * java.sql.Connection.
 *
 */
public interface RepositoryConnection extends LogEnabled {

    String CLASS_NAME_SUFFIX = "RepositoryConnection";

    /**
     * Commit all operation done with this active connection.
     */
    public void commit() throws SDXException;

    /**
     * Undo all operations done with this connection.
     */
    public void rollback() throws SDXException;

    /**
     * Sets this connection in autocommit mode or not.
     *
     * @param   autoCommit      true enables auto-commit ; false disables auto-commit.
     */
    public void setAutoCommit(boolean autoCommit) throws SDXException;

    /**Can do optimization of a Repository if needed*/
    public void optimize() throws SDXException;

}
