/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.eval;

import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.eval.EvaluationConstants;

class CodeSnippetToCuMapper
implements EvaluationConstants {
    public char[] cuSource;
    public int lineNumberOffset = 0;
    public int startPosOffset = 0;
    char[] codeSnippet;
    char[] snippetPackageName;
    char[][] snippetImports;
    char[] snippetClassName;
    char[] snippetVarClassName;
    char[] snippetDeclaringTypeName;
    char[][] localVarNames;
    char[][] localVarTypeNames;
    int[] localVarModifiers;

    public CodeSnippetToCuMapper(char[] codeSnippet, char[] packageName, char[][] imports, char[] className, char[] varClassName, char[][] localVarNames, char[][] localVarTypeNames, int[] localVarModifiers, char[] declaringTypeName) {
        this.codeSnippet = codeSnippet;
        this.snippetPackageName = packageName;
        this.snippetImports = imports;
        this.snippetClassName = className;
        this.snippetVarClassName = varClassName;
        this.localVarNames = localVarNames;
        this.localVarTypeNames = localVarTypeNames;
        this.localVarModifiers = localVarModifiers;
        this.snippetDeclaringTypeName = declaringTypeName;
        this.buildCUSource();
    }

    private void buildCUSource() {
        StringBuffer buffer = new StringBuffer();
        if (this.snippetPackageName != null && this.snippetPackageName.length != 0) {
            buffer.append("package ");
            buffer.append(this.snippetPackageName);
            buffer.append(";").append(Util.LINE_SEPARATOR);
            ++this.lineNumberOffset;
        }
        char[][] imports = this.snippetImports;
        int i = 0;
        while (i < imports.length) {
            buffer.append("import ");
            buffer.append(imports[i]);
            buffer.append(';').append(Util.LINE_SEPARATOR);
            ++this.lineNumberOffset;
            ++i;
        }
        buffer.append("public class ");
        buffer.append(this.snippetClassName);
        if (this.snippetVarClassName != null) {
            buffer.append(" extends ");
            buffer.append(this.snippetVarClassName);
        } else {
            buffer.append(" extends ");
            buffer.append(EvaluationConstants.PACKAGE_NAME);
            buffer.append(".");
            buffer.append(EvaluationConstants.ROOT_CLASS_NAME);
        }
        buffer.append(" {").append(Util.LINE_SEPARATOR);
        ++this.lineNumberOffset;
        if (this.snippetDeclaringTypeName != null) {
            buffer.append("  ");
            buffer.append(this.snippetDeclaringTypeName);
            buffer.append(" ");
            buffer.append(EvaluationConstants.DELEGATE_THIS);
            buffer.append(';').append(Util.LINE_SEPARATOR);
            ++this.lineNumberOffset;
        }
        if (this.localVarNames != null) {
            i = 0;
            int max = this.localVarNames.length;
            while (i < max) {
                buffer.append("    ");
                buffer.append(this.localVarTypeNames[i]);
                buffer.append(" ");
                buffer.append(EvaluationConstants.LOCAL_VAR_PREFIX);
                buffer.append(this.localVarNames[i]);
                buffer.append(';').append(Util.LINE_SEPARATOR);
                ++this.lineNumberOffset;
                ++i;
            }
        }
        buffer.append("public void run() throws Throwable {").append(Util.LINE_SEPARATOR);
        ++this.lineNumberOffset;
        this.startPosOffset = buffer.length();
        buffer.append(this.codeSnippet);
        buffer.append(Util.LINE_SEPARATOR).append('}').append(Util.LINE_SEPARATOR);
        buffer.append('}').append(Util.LINE_SEPARATOR);
        int length = buffer.length();
        this.cuSource = new char[length];
        buffer.getChars(0, length, this.cuSource, 0);
    }

    public ICompletionRequestor getCompletionRequestor(final ICompletionRequestor originalRequestor) {
        return new ICompletionRequestor(){

            public void acceptAnonymousType(char[] superTypePackageName, char[] superTypeName, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                originalRequestor.acceptAnonymousType(superTypePackageName, superTypeName, parameterPackageNames, parameterTypeNames, parameterNames, completionName, modifiers, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                if (CharOperation.equals(packageName, CodeSnippetToCuMapper.this.snippetPackageName) && (CharOperation.equals(className, CodeSnippetToCuMapper.this.snippetClassName) || CharOperation.equals(className, CodeSnippetToCuMapper.this.snippetVarClassName))) {
                    return;
                }
                originalRequestor.acceptClass(packageName, className, completionName, modifiers, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptError(IProblem error) {
                error.setSourceStart(error.getSourceStart() - CodeSnippetToCuMapper.this.startPosOffset);
                error.setSourceEnd(error.getSourceEnd() - CodeSnippetToCuMapper.this.startPosOffset);
                error.setSourceLineNumber(error.getSourceLineNumber() - CodeSnippetToCuMapper.this.lineNumberOffset);
                originalRequestor.acceptError(error);
            }

            public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                originalRequestor.acceptField(declaringTypePackageName, declaringTypeName, name, typePackageName, typeName, completionName, modifiers, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                originalRequestor.acceptInterface(packageName, interfaceName, completionName, modifiers, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptKeyword(char[] keywordName, int completionStart, int completionEnd, int relevance) {
                originalRequestor.acceptKeyword(keywordName, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptLabel(char[] labelName, int completionStart, int completionEnd, int relevance) {
                originalRequestor.acceptLabel(labelName, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
                originalRequestor.acceptLocalVariable(name, typePackageName, typeName, modifiers, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                if (CharOperation.equals(declaringTypePackageName, CodeSnippetToCuMapper.this.snippetPackageName) && CharOperation.equals(declaringTypeName, CodeSnippetToCuMapper.this.snippetClassName) && CharOperation.equals(selector, "run".toCharArray())) {
                    return;
                }
                originalRequestor.acceptMethod(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, parameterNames, returnTypePackageName, returnTypeName, completionName, modifiers, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                if (CharOperation.equals(declaringTypePackageName, CodeSnippetToCuMapper.this.snippetPackageName) && CharOperation.equals(declaringTypeName, CodeSnippetToCuMapper.this.snippetClassName) && CharOperation.equals(selector, "run".toCharArray())) {
                    return;
                }
                originalRequestor.acceptMethodDeclaration(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, parameterNames, returnTypePackageName, returnTypeName, completionName, modifiers, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptModifier(char[] modifierName, int completionStart, int completionEnd, int relevance) {
                originalRequestor.acceptModifier(modifierName, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptPackage(char[] packageName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                originalRequestor.acceptPackage(packageName, completionName, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptType(char[] packageName, char[] typeName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                if (CharOperation.equals(packageName, CodeSnippetToCuMapper.this.snippetPackageName) && (CharOperation.equals(CodeSnippetToCuMapper.this.snippetClassName, CodeSnippetToCuMapper.this.snippetClassName) || CharOperation.equals(CodeSnippetToCuMapper.this.snippetClassName, CodeSnippetToCuMapper.this.snippetVarClassName))) {
                    return;
                }
                originalRequestor.acceptType(packageName, typeName, completionName, completionStart - CodeSnippetToCuMapper.this.startPosOffset, completionEnd - CodeSnippetToCuMapper.this.startPosOffset, relevance);
            }

            public void acceptVariableName(char[] typePackageName, char[] typeName, char[] name, char[] completionName, int completionStart, int completionEnd, int relevance) {
                originalRequestor.acceptVariableName(typePackageName, typeName, name, completionName, completionStart, completionEnd, relevance);
            }
        };
    }

    public char[] getCUSource() {
        if (this.cuSource == null) {
            this.buildCUSource();
        }
        return this.cuSource;
    }

    public int getEvaluationType(int lineNumber) {
        int currentLine = 1;
        if (this.snippetPackageName != null && this.snippetPackageName.length != 0) {
            if (lineNumber == 1) {
                return 4;
            }
            ++currentLine;
        }
        char[][] imports = this.snippetImports;
        if (currentLine <= lineNumber && lineNumber < currentLine + imports.length) {
            return 3;
        }
        currentLine += imports.length + 1;
        if ((currentLine += (this.snippetDeclaringTypeName == null ? 0 : 1) + (this.localVarNames == null ? 0 : this.localVarNames.length)) > lineNumber) {
            return 5;
        }
        if (++currentLine >= this.lineNumberOffset) {
            return 2;
        }
        return 5;
    }

    public char[] getImport(int lineNumber) {
        int importStartLine = this.lineNumberOffset - 1 - this.snippetImports.length;
        return this.snippetImports[lineNumber - importStartLine];
    }

    public ISelectionRequestor getSelectionRequestor(final ISelectionRequestor originalRequestor) {
        return new ISelectionRequestor(){

            public void acceptClass(char[] packageName, char[] className, boolean needQualification, boolean isDeclaration, int start, int end) {
                originalRequestor.acceptClass(packageName, className, needQualification, isDeclaration, start, end);
            }

            public void acceptError(IProblem error) {
                error.setSourceLineNumber(error.getSourceLineNumber() - CodeSnippetToCuMapper.this.lineNumberOffset);
                error.setSourceStart(error.getSourceStart() - CodeSnippetToCuMapper.this.startPosOffset);
                error.setSourceEnd(error.getSourceEnd() - CodeSnippetToCuMapper.this.startPosOffset);
                originalRequestor.acceptError(error);
            }

            public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, boolean isDeclaration, int start, int end) {
                originalRequestor.acceptField(declaringTypePackageName, declaringTypeName, name, isDeclaration, start, end);
            }

            public void acceptInterface(char[] packageName, char[] interfaceName, boolean needQualification, boolean isDeclaration, int start, int end) {
                originalRequestor.acceptInterface(packageName, interfaceName, needQualification, isDeclaration, start, end);
            }

            public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, boolean isConstructor, boolean isDeclaration, int start, int end) {
                originalRequestor.acceptMethod(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, isConstructor, isDeclaration, start, end);
            }

            public void acceptPackage(char[] packageName) {
                originalRequestor.acceptPackage(packageName);
            }
        };
    }
}

