/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.common;

import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class LogContentHandler
implements ContentHandler {
    private ContentHandler handler = null;
    private Log log = null;

    public LogContentHandler(ContentHandler handler, Log log) {
        this.handler = handler;
        this.log = log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.log != null) {
            this.log.debug((Object)("[SAX] DocumentLocator " + locator));
        }
        this.handler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        if (this.log != null) {
            this.log.debug((Object)"[SAX] StartDocument");
        }
        this.handler.startDocument();
    }

    public void endDocument() throws SAXException {
        if (this.log != null) {
            this.log.debug((Object)"[SAX] EndDocument");
        }
        this.handler.endDocument();
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.log != null) {
            this.log.debug((Object)("[SAX] Characters \"" + new String(c, start, len) + "\""));
        }
        this.handler.characters(c, start, len);
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        if (this.log != null) {
            this.log.debug((Object)("[SAX] Ignorable Whitespace \"" + new String(c, start, len) + "\""));
        }
        this.handler.ignorableWhitespace(c, start, len);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.log != null) {
            this.log.debug((Object)("[SAX] Start Element " + localName + " Namespace " + namespaceURI));
        }
        this.handler.startElement(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String raw) throws SAXException {
        if (this.log != null) {
            this.log.debug((Object)("[SAX] End Element " + localName + " Namespace " + namespaceURI));
        }
        this.handler.endElement(namespaceURI, localName, raw);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.log != null) {
            this.log.debug((Object)("[SAX] Processing Instruction Target " + target + " Data " + data));
        }
        this.handler.processingInstruction(target, data);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.log != null) {
            this.log.debug((Object)("[SAX] Start Prefix Mapping " + prefix + " Namespace " + uri));
        }
        this.handler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.log != null) {
            this.log.debug((Object)("[SAX] Start Prefix Mapping " + prefix));
        }
        this.handler.endPrefixMapping(prefix);
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.log != null) {
            this.log.debug((Object)("[SAX] Skipped Entity " + name));
        }
        this.handler.skippedEntity(name);
    }
}

