/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.taglib.core;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.taglib.XMLProducerTagSupport;
import org.apache.cocoon.xml.EmbeddedXMLPipe;
import org.apache.excalibur.source.Source;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SourceTag
extends XMLProducerTagSupport {
    private String src;
    private EmbeddedXMLPipe embeddedXMLPipe = new EmbeddedXMLPipe(null);

    public void setSrc(String src) {
        this.src = src;
    }

    public int doEndTag(String namespaceURI, String localName, String qName) throws SAXException {
        Source source = null;
        try {
            this.embeddedXMLPipe.setConsumer(this.xmlConsumer);
            source = this.resolver.resolveURI(this.src);
            SourceUtil.toSAX((Source)source, (ContentHandler)this.embeddedXMLPipe);
        }
        catch (Exception e) {
            ProcessingException pe;
            Throwable t;
            if (e instanceof ProcessingException && (t = (pe = (ProcessingException)e).getCause()) != null && t instanceof SAXException) {
                throw (SAXException)t;
            }
            throw new SAXException(e.getMessage(), e);
        }
        finally {
            this.embeddedXMLPipe.setConsumer(null);
            if (source != null) {
                this.resolver.release(source);
            }
        }
        return 2;
    }

    public void recycle() {
        this.src = null;
        super.recycle();
    }
}

