/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;
import org.apache.cocoon.components.modules.input.ModuleHolder;

public class ChainMetaModule
extends AbstractMetaModule
implements ThreadSafe {
    private ModuleHolder[] inputs = null;
    private boolean emptyAsNull = false;
    private boolean allNames = false;
    private boolean allValues = false;

    public void configure(Configuration config) throws ConfigurationException {
        Configuration[] confs = config.getChildren("input-module");
        if (confs.length > 0) {
            this.inputs = new ModuleHolder[confs.length];
            int j = 0;
            for (int i = 0; i < confs.length; ++i) {
                ModuleHolder module = new ModuleHolder();
                module.name = confs[i].getAttribute("name", null);
                if (module.name == null) {
                    if (!this.getLogger().isErrorEnabled()) continue;
                    this.getLogger().error("No name attribute for module configuration. Skipping.");
                    continue;
                }
                module.config = confs[i];
                this.inputs[j] = module;
                ++j;
            }
        }
        this.emptyAsNull = config.getChild("empty-as-null").getValueAsBoolean(this.emptyAsNull);
        this.allNames = config.getChild("all-names").getValueAsBoolean(this.allNames);
        this.allValues = config.getChild("all-values").getValueAsBoolean(this.allValues);
    }

    public synchronized void lazy_initialize() {
        block7: {
            try {
                if (!this.initialized) {
                    this.inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    if (this.inputSelector != null && this.inputSelector instanceof ThreadSafe) {
                        for (int i = 0; i < this.inputs.length; ++i) {
                            if (this.inputs[i].name == null) continue;
                            this.inputs[i].input = this.obtainModule(this.inputs[i].name);
                        }
                    } else if (!(this.inputSelector instanceof ThreadSafe)) {
                        this.manager.release((Component)this.inputSelector);
                        this.inputSelector = null;
                    }
                    this.initialized = true;
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block7;
                this.getLogger().warn("A problem occurred setting up input modules :'" + e.getMessage());
            }
        }
    }

    public void dispose() {
        if (this.inputSelector != null) {
            for (int i = 0; i < this.inputs.length; ++i) {
                if (this.inputs[i].input == null) continue;
                this.inputSelector.release((Component)this.inputs[i].input);
            }
            this.manager.release((Component)this.inputSelector);
        }
    }

    public Object[] getAttributeValues(String attr, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        Configuration[] inputConfigs = null;
        boolean allValues = this.allValues;
        boolean emptyAsNull = this.emptyAsNull;
        if (modeConf != null && modeConf.getChildren().length > 0) {
            inputConfigs = modeConf.getChildren("input-module");
            emptyAsNull = modeConf.getChild("empty-as-null").getValueAsBoolean(emptyAsNull);
            allValues = modeConf.getChild("all-values").getValueAsBoolean(allValues);
            if (inputConfigs.length == 0) {
                inputConfigs = null;
            }
        }
        Object[] value = null;
        boolean debug = this.getLogger().isDebugEnabled();
        ArrayList<Object> values = null;
        if (allValues) {
            values = new ArrayList<Object>();
        }
        if (inputConfigs == null) {
            for (int i = 0; i < this.inputs.length && (value == null || allValues); ++i) {
                if (this.inputs[i].name == null) continue;
                value = this.getValues(attr, objectModel, this.inputs[i].input, this.inputs[i].name, this.inputs[i].config);
                if (emptyAsNull && value != null && value.length == 0) {
                    value = null;
                }
                if (emptyAsNull && value != null && value.length == 1 && value[0] instanceof String && value[0].equals("")) {
                    value = null;
                }
                if (debug) {
                    this.getLogger().debug("read from " + this.inputs[i].name + " attribute " + attr + " as " + value);
                }
                if (!allValues || value == null) continue;
                values.addAll(Arrays.asList(value));
            }
        } else {
            for (int i = 0; i < inputConfigs.length && (value == null || allValues); ++i) {
                String name = inputConfigs[i].getAttribute("name", null);
                if (name == null) continue;
                value = this.getValues(attr, objectModel, null, name, inputConfigs[i]);
                if (emptyAsNull && value != null && value.length == 0) {
                    value = null;
                }
                if (emptyAsNull && value != null && value.length == 1 && value[0] instanceof String && value[0].equals("")) {
                    value = null;
                }
                if (debug) {
                    this.getLogger().debug("read from " + name + " attribute " + attr + " as " + value);
                }
                if (!allValues || value == null) continue;
                values.addAll(Arrays.asList(value));
            }
        }
        if (debug) {
            this.getLogger().debug("result chaining for " + attr + " is " + (allValues ? values.toArray() : value));
        }
        return allValues ? values.toArray() : value;
    }

    private void addIterator(Collection col, Iterator iter) {
        while (iter != null && iter.hasNext()) {
            col.add(iter.next());
        }
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        Configuration[] inputConfigs = null;
        boolean emptyAsNull = this.emptyAsNull;
        boolean allNames = this.allNames;
        if (modeConf != null && modeConf.getChildren().length > 0) {
            inputConfigs = modeConf.getChildren("input-module");
            emptyAsNull = modeConf.getChild("empty-as-null").getValueAsBoolean(emptyAsNull);
            allNames = modeConf.getChild("all-names").getValueAsBoolean(allNames);
            if (inputConfigs.length == 0) {
                inputConfigs = null;
            }
        }
        Iterator value = null;
        ArrayList values = null;
        if (allNames) {
            values = new ArrayList();
        }
        boolean debug = this.getLogger().isDebugEnabled();
        if (inputConfigs == null) {
            for (int i = 0; i < this.inputs.length && (value == null || allNames); ++i) {
                if (this.inputs[i].name == null) continue;
                value = this.getNames(objectModel, this.inputs[i].input, this.inputs[i].name, this.inputs[i].config);
                if (debug) {
                    this.getLogger().debug("read from " + this.inputs[i].name + " AttributeNames as " + value);
                }
                if (!allNames || value == null) continue;
                this.addIterator(values, value);
            }
        } else {
            for (int i = 0; i < inputConfigs.length && value == null; ++i) {
                String name = inputConfigs[i].getAttribute("name", null);
                if (name == null) continue;
                value = this.getNames(objectModel, null, name, inputConfigs[i]);
                if (debug) {
                    this.getLogger().debug("read from " + name + " AttributeNames as " + value);
                }
                if (!allNames || value == null) continue;
                this.addIterator(values, value);
            }
        }
        if (debug) {
            this.getLogger().debug("result chaining names is " + (allNames ? values.iterator() : value));
        }
        return allNames ? values.iterator() : value;
    }

    public Object getAttribute(String attr, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Object[] values = this.getAttributeValues(attr, modeConf, objectModel);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("result chaining single for " + attr + " is " + (values != null ? values[0] : "null"));
        }
        return values != null ? values[0] : null;
    }
}

