/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import de.tivano.flash.swf.parser.SWFReader;
import de.tivano.flash.swf.parser.SWFTagReader;
import de.tivano.flash.swf.parser.SWFVerboseDefineFont2Reader;
import de.tivano.flash.swf.parser.SWFVerboseDefineFontReader;
import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.FileGenerator;
import org.apache.excalibur.source.SourceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SWFGenerator
extends FileGenerator {
    private boolean pVerbose = false;
    private SWFReader parser;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.parser = new SWFReader();
        if (this.pVerbose) {
            this.parser.registerTagReader(48, (SWFTagReader)new SWFVerboseDefineFont2Reader());
            this.parser.registerTagReader(10, (SWFTagReader)new SWFVerboseDefineFontReader());
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("processing file " + this.source);
                this.getLogger().debug("file resolved to " + this.inputSource.getURI());
            }
            this.parser.setContentHandler((ContentHandler)this.xmlConsumer);
            this.parser.parse(new InputSource(this.inputSource.getInputStream()));
        }
        catch (SourceException e) {
            throw new ProcessingException("Could not read resource " + this.inputSource.getURI(), (Throwable)e);
        }
        catch (SAXException e) {
            Exception cause = e.getException();
            if (cause != null) {
                this.getLogger().debug("Got SAXException; Rethrowing cause exception", (Throwable)e);
                if (cause instanceof ProcessingException) {
                    throw (ProcessingException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof SAXException) {
                    throw (SAXException)cause;
                }
                throw new ProcessingException("Could not read resource " + this.inputSource.getURI(), (Throwable)cause);
            }
            throw e;
        }
    }
}

