/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers.encoding;

import org.apache.cocoon.components.serializers.encoding.AbstractCharset;

public abstract class CompiledCharset
extends AbstractCharset {
    protected byte[] encoding;

    protected CompiledCharset(String name, String[] aliases) {
        super(name, aliases);
        this.encoding = new byte[8192];
        int x = 0;
        while (x < this.encoding.length) {
            this.encoding[x] = 0;
            ++x;
        }
    }

    protected CompiledCharset(String name, String[] aliases, byte[] encoding) throws NullPointerException, IllegalArgumentException {
        super(name, aliases);
        if (encoding == null) {
            throw new NullPointerException("Invalid table");
        }
        if (encoding.length != 8192) {
            throw new IllegalArgumentException("Invalid encoding table size: current length is " + encoding.length + ", required 8192.");
        }
        this.encoding = encoding;
    }

    public boolean allows(char c) {
        return (this.encoding[c >> 3] & 1 << (c & 7)) > 0;
    }

    protected final void compile() {
        int x = 0;
        while (x <= 65535) {
            if (this.compile((char)x)) {
                int pos = x >> 3;
                this.encoding[pos] = (byte)(this.encoding[pos] | 1 << (x & 7));
            }
            ++x;
        }
    }

    protected abstract boolean compile(char var1);
}

