/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.transformation;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Map;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.application.PortalApplicationConfig;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.profile.ProfileManager;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProxyTransformer
extends AbstractTransformer
implements Serviceable,
Parameterizable {
    public static String ENVELOPE_TAG_PARAMETER = "envelope-tag";
    public static final String PORTALNAME = "cocoon-portal-portalname";
    public static final String COPLETID = "cocoon-portal-copletid";
    public static final String PROXY_PREFIX = "proxy-";
    public static final String COPLET_ID_PARAM = "copletId";
    public static final String PORTAL_NAME_PARAM = "portalName";
    public static final String SESSIONTOKEN = "sessiontoken";
    public static final String COOKIE = "cookie";
    public static final String START_URI = "start-uri";
    public static final String LINK = "link";
    public static final String CONFIG = "config";
    public static final String DOCUMENT_BASE = "documentbase";
    public static String PROTOCOL_HANDLER_PARAMETER = "protocol-handler";
    protected String documentBase;
    protected String link;
    protected String envelopeTag;
    protected ServiceManager manager;
    protected CopletInstanceData copletInstanceData;
    protected Request request;
    protected int configuredEncoding;
    protected String userAgent = null;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void parameterize(Parameters parameters) {
        if (parameters != null) {
            this.envelopeTag = parameters.getParameter(ENVELOPE_TAG_PARAMETER, null);
            String protocolHandler = parameters.getParameter(PROTOCOL_HANDLER_PARAMETER, null);
            if (protocolHandler != null && System.getProperty("java.protocol.handler.pkgs") == null) {
                System.setProperty("java.protocol.handler.pkgs", protocolHandler);
            }
        }
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.request = ObjectModelHelper.getRequest((Map)objectModel);
        this.copletInstanceData = ProxyTransformer.getInstanceData(this.manager, objectModel, parameters);
        PortalApplicationConfig pac = (PortalApplicationConfig)this.copletInstanceData.getAttribute(CONFIG);
        String startURI = pac.getAttribute(START_URI);
        this.link = (String)this.copletInstanceData.getAttribute(LINK);
        this.documentBase = (String)this.copletInstanceData.getAttribute(DOCUMENT_BASE);
        if (this.link == null) {
            this.link = startURI;
        }
        if (this.documentBase == null) {
            this.documentBase = this.link.substring(0, this.link.lastIndexOf(47) + 1);
            this.copletInstanceData.setAttribute(DOCUMENT_BASE, this.documentBase);
        }
        String encodingString = pac.getAttribute("encoding");
        this.configuredEncoding = this.encodingConstantFromString(encodingString);
        this.userAgent = pac.getAttribute("user-agent");
        this.envelopeTag = parameters.getParameter("envelope-tag", this.envelopeTag);
        if (this.envelopeTag == null) {
            throw new ProcessingException("Can not initialize RSFHtmlTransformer - sitemap parameter envelope-tag missing");
        }
        String protocolHandler = parameters.getParameter(PROTOCOL_HANDLER_PARAMETER, null);
        if (protocolHandler != null) {
            System.setProperty("java.protocol.handler.pkgs", protocolHandler);
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        super.startElement(uri, name, raw, attributes);
        if (name.equalsIgnoreCase(this.envelopeTag)) {
            this.processRequest();
        }
    }

    protected void processRequest() throws SAXException {
        try {
            String remoteURI = null;
            try {
                remoteURI = ProxyTransformer.resolveURI(this.link, this.documentBase);
            }
            catch (MalformedURLException ex) {
                throw new SAXException(ex);
            }
            StringBuffer query = new StringBuffer();
            boolean firstparameter = true;
            Enumeration enumeration = this.request.getParameterNames();
            boolean post = "POST".equals(this.request.getMethod());
            while (enumeration.hasMoreElements()) {
                String paramName = (String)enumeration.nextElement();
                if (paramName.startsWith("cocoon-portal-")) continue;
                String[] paramValues = this.request.getParameterValues(paramName);
                int i = 0;
                while (i < paramValues.length) {
                    if (firstparameter) {
                        if (!post) {
                            query.append('?');
                        }
                        firstparameter = false;
                    } else {
                        query.append('&');
                    }
                    query.append(URLEncoder.encode(paramName));
                    query.append('=');
                    query.append(URLEncoder.encode(paramValues[i]));
                    ++i;
                }
            }
            Document result = null;
            try {
                do {
                    HttpURLConnection connection;
                    if ((remoteURI = this.checkForRedirect(connection = this.connect(this.request, remoteURI, query.toString(), post), this.documentBase)) != null) continue;
                    result = this.readXML(connection);
                    remoteURI = this.checkForRedirect(result, this.documentBase);
                } while (remoteURI != null);
            }
            catch (IOException ex) {
                throw new SAXException("Failed to retrieve remoteURI " + remoteURI, ex);
            }
            XMLUtils.stripDuplicateAttributes((Node)result, null);
            DOMStreamer streamer = new DOMStreamer();
            streamer.setContentHandler(this.contentHandler);
            streamer.stream((Node)result.getDocumentElement());
        }
        catch (SAXException se) {
            throw se;
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    protected String checkForRedirect(HttpURLConnection connection, String documentBase) throws IOException {
        if (connection.getResponseCode() == 301 || connection.getResponseCode() == 302) {
            String newURI = connection.getHeaderField("location");
            int index_semikolon = newURI.indexOf(";");
            int index_question = newURI.indexOf("?");
            if (index_semikolon > -1) {
                String sessionToken = newURI.substring(index_semikolon + 1, index_question == -1 ? newURI.length() : index_question);
                this.copletInstanceData.getPersistentAspectData().put(SESSIONTOKEN, sessionToken);
            }
            if (newURI != null) {
                newURI = ProxyTransformer.resolveURI(newURI, documentBase);
            }
            return newURI;
        }
        return null;
    }

    protected String checkForRedirect(Document doc, String documentBase) throws MalformedURLException {
        Element htmlElement = doc.getDocumentElement();
        NodeList headList = htmlElement.getElementsByTagName("head");
        if (headList.getLength() <= 0) {
            return null;
        }
        Element headElement = (Element)headList.item(0);
        NodeList metaList = headElement.getElementsByTagName("meta");
        int i = 0;
        while (i < metaList.getLength()) {
            String content;
            Element metaElement = (Element)metaList.item(i);
            String httpEquiv = metaElement.getAttribute("http-equiv");
            if ("refresh".equalsIgnoreCase(httpEquiv) && (content = metaElement.getAttribute("content")) != null) {
                String time = content.substring(0, content.indexOf(59));
                try {
                    if (Integer.parseInt(time) > 10) {
                        this.getLogger().warn("Redirects with refresh time longer than 10 seconds (" + time + " seconds) will be ignored!");
                        return null;
                    }
                }
                catch (NumberFormatException ex) {
                    this.getLogger().warn("Failed to convert refresh time from redirect to integer: " + time);
                    return null;
                }
                String newURI = content.substring(content.indexOf(61) + 1);
                int index_semikolon = newURI.indexOf(";");
                int index_question = newURI.indexOf("?");
                if (index_semikolon > -1) {
                    String sessionToken = newURI.substring(index_semikolon + 1, index_question == -1 ? newURI.length() : index_question);
                    this.copletInstanceData.getPersistentAspectData().put(SESSIONTOKEN, sessionToken);
                }
                if (newURI != null) {
                    newURI = ProxyTransformer.resolveURI(newURI, documentBase);
                }
                return newURI;
            }
            ++i;
        }
        return null;
    }

    protected Document readXML(HttpURLConnection connection) throws SAXException {
        try {
            int charEncoding = this.configuredEncoding;
            String contentType = connection.getHeaderField("Content-Type");
            int begin = contentType.indexOf("charset=");
            int end = -1;
            if (begin > -1) {
                end = contentType.indexOf(59, begin += "charset=".length());
                if (end == -1) {
                    end = contentType.length();
                }
                String charset = contentType.substring(begin, end);
                charEncoding = this.encodingConstantFromString(charset);
            }
            InputStream stream = connection.getInputStream();
            Tidy tidy = new Tidy();
            tidy.setXmlOut(true);
            tidy.setCharEncoding(charEncoding);
            tidy.setXHTML(true);
            tidy.setShowWarnings(this.getLogger().isWarnEnabled());
            tidy.setQuiet(!this.getLogger().isInfoEnabled());
            StringWriter stringWriter = new StringWriter();
            PrintWriter errorWriter = new PrintWriter(stringWriter);
            tidy.setErrout(errorWriter);
            Document doc = tidy.parseDOM((InputStream)new BufferedInputStream(stream), null);
            errorWriter.flush();
            errorWriter.close();
            return doc;
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    private int encodingConstantFromString(String encoding) {
        if ("ISO8859_1".equalsIgnoreCase(encoding)) {
            return 2;
        }
        if ("UTF-8".equalsIgnoreCase(encoding)) {
            return 3;
        }
        return 2;
    }

    protected HttpURLConnection connect(Request request, String uri, String query, boolean post) throws IOException {
        String cookie = (String)this.copletInstanceData.getAttribute(COOKIE);
        if (!post) {
            uri = uri + query;
        }
        URL url = new URL(uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(request.getMethod());
        connection.setRequestProperty("User-Agent", this.userAgent != null ? this.userAgent : request.getHeader("User-Agent"));
        connection.setRequestProperty("Accept-Language", request.getHeader("Accept-Language"));
        if (cookie != null) {
            connection.setRequestProperty(COOKIE, cookie);
        }
        if (post) {
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Length", String.valueOf(query.length()));
        }
        connection.connect();
        if (post) {
            PrintWriter out = new PrintWriter(connection.getOutputStream());
            out.print(query);
            out.close();
        }
        this.copletInstanceData.setAttribute(COOKIE, connection.getHeaderField(COOKIE));
        this.documentBase = uri.substring(0, uri.lastIndexOf(47) + 1);
        this.copletInstanceData.setAttribute(DOCUMENT_BASE, this.documentBase);
        return connection;
    }

    public static String resolveURI(String uri, String documentBase) throws MalformedURLException {
        if (uri.indexOf("://") > -1) {
            return uri;
        }
        if (uri == null) {
            throw new IllegalArgumentException("URI to be resolved must not be null!");
        }
        if (documentBase == null) {
            throw new IllegalArgumentException("Documentbase String must not be null!");
        }
        if (uri.startsWith("./")) {
            uri = uri.substring(2);
        }
        URL documentBaseURL = new URL(documentBase);
        if (uri.startsWith("/")) {
            return documentBaseURL.getProtocol() + "://" + documentBaseURL.getAuthority() + uri;
        }
        return documentBaseURL.toExternalForm() + uri;
    }

    public static CopletInstanceData getInstanceData(ServiceManager manager, String copletID, String portalName) throws ProcessingException {
        CopletInstanceData copletInstanceData;
        PortalService portalService = null;
        try {
            CopletInstanceData data;
            portalService = (PortalService)manager.lookup(PortalService.ROLE);
            portalService.setPortalName(portalName);
            ProfileManager profileManager = portalService.getComponentManager().getProfileManager();
            copletInstanceData = data = profileManager.getCopletInstanceData(copletID);
            Object var8_8 = null;
        }
        catch (ServiceException e) {
            try {
                throw new ProcessingException("Error getting portal service.", (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                manager.release((Object)portalService);
                throw throwable;
            }
        }
        manager.release((Object)portalService);
        return copletInstanceData;
    }

    public static CopletInstanceData getInstanceData(ServiceManager manager, Map objectModel, Parameters parameters) throws ProcessingException {
        CopletInstanceData copletInstanceData;
        PortalService portalService = null;
        try {
            portalService = (PortalService)manager.lookup(PortalService.ROLE);
            String copletId = null;
            Map context = (Map)objectModel.get("parent-context");
            if (context != null) {
                copletId = (String)context.get("cocoon-portal-copletId");
                if (copletId == null) {
                    throw new ProcessingException("copletId must be passed as parameter or in the object model within the parent context.");
                }
            } else {
                try {
                    copletId = parameters.getParameter(COPLET_ID_PARAM);
                    portalService.setPortalName(parameters.getParameter(PORTAL_NAME_PARAM));
                }
                catch (ParameterException e) {
                    throw new ProcessingException("copletId and portalName must be passed as parameter or in the object model within the parent context.");
                }
            }
            copletInstanceData = portalService.getComponentManager().getProfileManager().getCopletInstanceData(copletId);
            Object var8_9 = null;
        }
        catch (ServiceException e) {
            try {
                throw new ProcessingException("Error getting portal service.", (Throwable)e);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                manager.release((Object)portalService);
                throw throwable;
            }
        }
        manager.release((Object)portalService);
        return copletInstanceData;
    }
}

