/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.serialization;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;

class ReplacingOutputStream
extends OutputStream {
    protected final OutputStream stream;
    protected boolean inKey;
    protected final LinkedList orderedValues;

    public ReplacingOutputStream(OutputStream stream, LinkedList values) {
        this.stream = stream;
        this.orderedValues = values;
        this.inKey = false;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (this.inKey) {
            if (b[off] == 126) {
                this.writeNextValue();
                ++off;
                --len;
            } else {
                this.write(126);
            }
            this.inKey = false;
        }
        boolean end = false;
        do {
            int l;
            int s = off;
            int e = off + len;
            while (s < e && b[s] != 126) {
                ++s;
            }
            if (s == e) {
                this.stream.write(b, off, len);
                end = true;
                continue;
            }
            if (s == e - 1) {
                this.stream.write(b, off, len - 1);
                this.inKey = true;
                end = true;
                continue;
            }
            if (b[s + 1] == 126) {
                l = s - off;
                this.stream.write(b, off, l);
                off += l + 2;
                len -= l + 2;
                this.writeNextValue();
            } else {
                l = s - off + 2;
                this.stream.write(b, off, l);
                off += l;
                len -= l;
            }
            boolean bl = end = len == 0;
        } while (!end);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        if (b == 126) {
            if (this.inKey) {
                this.writeNextValue();
            }
            this.inKey = !this.inKey;
        } else {
            if (this.inKey) {
                this.inKey = false;
                this.stream.write(126);
            }
            this.stream.write(b);
        }
    }

    protected void writeNextValue() throws IOException {
        String value = (String)this.orderedValues.removeLast();
        if (value != null) {
            this.stream.write(value.getBytes(), 0, value.length());
        }
    }
}

